/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.ShortCursor;
import com.koloboke.collect.ShortIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.AbstractShortValueView;
import com.koloboke.collect.impl.CommonByteShortMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteShortMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVByteShortMapSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVByteShortQHash;
import com.koloboke.collect.map.ByteShortCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.ShortSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteShortConsumer;
import com.koloboke.function.ByteShortPredicate;
import com.koloboke.function.ByteShortToShortFunction;
import com.koloboke.function.ByteToShortFunction;
import com.koloboke.function.ShortBinaryOperator;
import com.koloboke.function.ShortConsumer;
import com.koloboke.function.ShortPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVByteShortMapGO
extends MutableQHashSeparateKVByteShortMapSO {
    @Override
    final void copy(SeparateKVByteShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    public boolean containsEntry(byte key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Short get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public short get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Short getOrDefault(Object key, Short defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public short getOrDefault(byte key, short defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Byte)key, (Short)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Byte)key, (Short)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || predicate.test(key, vals[i])) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteShortCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteShortMapOps.containsAllEntries((InternalByteShortMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                hashCode += key ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += key ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        byte[] newKeys = this.set;
        int capacity = newKeys.length;
        short[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Short put(Byte key, Short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public short put(byte key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        short[] vals = this.values;
        short prevValue = vals[index];
        vals[index] = value;
        return prevValue;
    }

    public Short putIfAbsent(Byte key, Short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public short putIfAbsent(byte key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return this.defaultValue();
        }
        return this.values[index];
    }

    public void justPut(byte key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public Short compute(Byte key, BiFunction<? super Byte, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        byte removed;
        byte k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix((byte)k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                Short newValue2;
                block29: {
                    if (cur != free) {
                        Short newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Byte)k, null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = newValue3;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Byte)k, null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = newValue2;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)k, (Short)vals[index])) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public short compute(byte key, ByteShortToShortFunction remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = remappingFunction.applyAsShort(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(key, vals[index]);
        return newValue;
    }

    public Short computeIfAbsent(Byte key, Function<? super Byte, ? extends Short> mappingFunction) {
        Short value;
        byte k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)k) % capacity;
            byte cur = keys[index];
            if (cur == k) {
                return vals[index];
            }
            if (cur != free) {
                Short value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return vals[bIndex];
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return vals[fIndex];
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return vals[bIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return vals[fIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Byte)k)) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = value2;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Byte)k)) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = value;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(byte key, ByteToShortFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            short[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur == key) {
                return vals[index];
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return vals[bIndex];
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return vals[fIndex];
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return vals[bIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return vals[fIndex];
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                short value = mappingFunction.applyAsShort(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = value;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = value;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Short computeIfPresent(Byte key, BiFunction<? super Byte, ? super Short, ? extends Short> remappingFunction) {
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            short[] vals = this.values;
            Short newValue = remappingFunction.apply((Byte)k, (Short)vals[index]);
            if (newValue != null) {
                vals[index] = newValue;
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public short computeIfPresent(byte key, ByteShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            short newValue;
            short[] vals = this.values;
            vals[index] = newValue = remappingFunction.applyAsShort(key, vals[index]);
            return newValue;
        }
        return this.defaultValue();
    }

    public Short merge(Byte key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int index;
        short[] vals;
        byte removed;
        block27: {
            byte k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix((byte)k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)vals[index], value)) != null) {
            vals[index] = newValue;
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public short merge(byte key, short value, ShortBinaryOperator remappingFunction) {
        short newValue;
        int index;
        short[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = value;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = value;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        vals[index] = newValue = remappingFunction.applyAsShort(vals[index], value);
        return newValue;
    }

    public short addValue(byte key, short value) {
        short newValue;
        int index;
        short[] vals;
        block24: {
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = (short)(this.defaultValue() + value);
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (short)(this.defaultValue() + value);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (short)(vals[index] + value);
        return newValue;
    }

    public short addValue(byte key, short addition, short initialValue) {
        short newValue;
        int index;
        short[] vals;
        block24: {
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            byte[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = (short)(initialValue + addition);
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = newValue2;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (short)(initialValue + addition);
                this.incrementModCount();
                keys[index] = key;
                vals[index] = newValue;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        vals[index] = newValue = (short)(vals[index] + addition);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Short> m) {
        CommonByteShortMapOps.putAll((InternalByteShortMapOps)this, m);
    }

    public Short replace(Byte key, Short value) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return null;
    }

    public short replace(byte key, short value) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            short oldValue = vals[index];
            vals[index] = value;
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Byte key, Short oldValue, Short newValue) {
        return this.replace((byte)key, (short)oldValue, (short)newValue);
    }

    public boolean replace(byte key, short oldValue, short newValue) {
        int index = this.index(key);
        if (index >= 0) {
            short[] vals = this.values;
            if (vals[index] == oldValue) {
                vals[index] = newValue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Byte, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                vals[i] = function.apply((Byte)key, (Short)vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.apply((Byte)key, (Short)vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                vals[i] = function.applyAsShort(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = function.applyAsShort(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Short remove(Object key) {
        byte removed;
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)k) % capacity;
            byte cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            short val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public short remove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short val = this.values[index];
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Short)value);
    }

    public boolean remove(byte key, short value) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            byte[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVByteKeyMixing.mix((byte)key) % capacity;
            byte cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == value) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ByteShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        byte[] keys = this.set;
        short[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed || !filter.test(key, vals[i])) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ByteShortCursor {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        short curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ByteShortCursor {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ShortCursor {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        short curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ShortIterator {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    byte removed = this.removed;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = this.vals[nextI];
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Short)vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Short>> {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        short curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Short> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Short>> {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Short> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    byte removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Short>> {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Short> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                byte[] keys = this.keys;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Short>> {
        final byte[] keys;
        final short[] vals;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            this.vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            byte free = this.free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            byte[] keys = this.keys;
            short[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Short> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    byte[] keys = this.keys;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        byte key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashSeparateKVByteShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVByteShortMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVByteShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableQHashSeparateKVByteShortMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept((Short)vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Short)vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || predicate.test(vals[i])) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeShort(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeShort(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = vals[i];
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = vals[i];
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(vals[i]).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableQHashSeparateKVByteShortMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashSeparateKVByteShortMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test((Short)vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test((Short)vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ByteShortEntry {
        private byte key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteShortEntry {
        final int modCount;
        private final int index;
        final byte key;
        private short value;

        MutableEntry(int modCount, int index, byte key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            MutableQHashSeparateKVByteShortMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class ByteShortEntry
    extends AbstractEntry<Byte, Short> {
        ByteShortEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract short value();

        public final Short getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((short)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Short>>
    implements HashObjSet<Map.Entry<Byte, Short>>,
    InternalObjCollectionOps<Map.Entry<Byte, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVByteShortMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVByteShortMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVByteShortMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVByteShortMapGO.this.containsEntry((Byte)e.getKey(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    action.accept((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || predicate.test((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || predicate.test((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Short>> iterator() {
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Short>> cursor() {
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            if (!MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVByteShortMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(vals[i]);
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVByteShortMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                short value = (Short)e.getValue();
                return MutableQHashSeparateKVByteShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || !filter.test((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !filter.test((Map.Entry<Byte, Short>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVByteShortMapGO.this.modCount();
            byte free = MutableQHashSeparateKVByteShortMapGO.this.freeValue;
            byte removed = MutableQHashSeparateKVByteShortMapGO.this.removedValue;
            byte[] keys = MutableQHashSeparateKVByteShortMapGO.this.set;
            short[] vals = MutableQHashSeparateKVByteShortMapGO.this.values;
            if (MutableQHashSeparateKVByteShortMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    byte key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVByteShortMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVByteShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVByteShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVByteShortMapGO.this.doClear();
        }
    }
}

