/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.CharCollection;
import com.koloboke.collect.CharCursor;
import com.koloboke.collect.impl.CommonCharCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalCharCollectionOps;
import com.koloboke.collect.impl.hash.MutableCharQHashSetSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVCharQHash;
import com.koloboke.collect.set.CharSet;
import com.koloboke.collect.set.hash.HashCharSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableQHashCharSetGO
extends MutableCharQHashSetSO
implements HashCharSet,
InternalCharCollectionOps {
    @Override
    final void copy(SeparateKVCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonCharCollectionOps.containsAll((CharCollection)this, c);
    }

    @Nonnull
    public CharCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Character e) {
        return this.add(e.charValue());
    }

    public boolean add(char key) {
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Character> c) {
        return CommonCharCollectionOps.addAll((CharCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeChar(((Character)key).charValue());
    }

    @Override
    boolean justRemove(char key) {
        return this.removeChar(key);
    }

    public boolean removeChar(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof CharCollection) {
            InternalCharCollectionOps c2;
            if (c instanceof InternalCharCollectionOps && (c2 = (InternalCharCollectionOps)c).size() < this.size()) {
                return c2.reverseRemoveAllFrom((CharSet)this);
            }
            return this.removeAll((HashCharSet)this, (CharCollection)c);
        }
        return this.removeAll((HashCharSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

