/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.LongArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableLHash;
import com.koloboke.collect.impl.hash.ParallelKVDoubleLHash;

public abstract class MutableParallelKVDoubleLHashSO
extends MutableLHash
implements ParallelKVDoubleLHash,
PrimitiveConstants,
UnsafeConstants {
    long[] table;

    void copy(ParallelKVDoubleLHash hash) {
        super.copy(hash);
        this.table = (long[])hash.table().clone();
    }

    void move(ParallelKVDoubleLHash hash) {
        super.copy(hash);
        this.table = hash.table();
    }

    public boolean contains(Object key) {
        return this.contains((Double)key);
    }

    public boolean contains(double key) {
        return this.index(Double.doubleToLongBits(key)) >= 0;
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long[] tab = this.table;
        int capacityMask = tab.length - 2;
        int index = LHash.ParallelKVDoubleKeyMixing.mix((long)key) & capacityMask;
        long cur = tab[index];
        if (cur == key) {
            return index;
        }
        if (cur == 0x7FFFFFFFFFFFFFFEL) {
            return -1;
        }
        do {
            if ((cur = tab[index = index - 2 & capacityMask]) != key) continue;
            return index;
        } while (cur != 0x7FFFFFFFFFFFFFFEL);
        return -1;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity * 2];
        LongArrays.fillKeys((long[])this.table, (long)0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public void clear() {
        super.clear();
        LongArrays.fillKeys((long[])this.table, (long)0x7FFFFFFFFFFFFFFEL);
    }
}

