/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.MutableParallelKVByteLHashSO;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.hash.HashByteSet;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class MutableParallelKVByteLHashGO
extends MutableParallelKVByteLHashSO {
    @Override
    @Nonnull
    public char[] table() {
        return this.table;
    }

    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            action.accept((Byte)key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            action.accept(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(BytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free || predicate.test(key)) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    public boolean allContainingIn(ByteCollection c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(ByteCollection c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            changed |= c.add(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(ByteSet s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            changed |= s.removeByte(key);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public ByteIterator iterator() {
        int mc = this.modCount();
        return new NoRemovedIterator(mc);
    }

    public ByteCursor setCursor() {
        int mc = this.modCount();
        return new NoRemovedCursor(mc);
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public byte[] toByteArray() {
        int size = this.size();
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            result[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return result;
    }

    @Nonnull
    public byte[] toArray(byte[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new byte[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0;
            }
            return a;
        }
        int resultIndex = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            a[resultIndex++] = key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            hashCode += key;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        long base = CHAR_BASE + BYTE_KEY_OFFSET;
        long off = (long)tab.length << 1;
        while ((off -= 2L) >= 0L) {
            byte key = U.getByte(tab, base + off);
            if (key == free) continue;
            sb.append(' ').append(key).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(byte var1);

    public boolean removeIf(Predicate<? super Byte> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || !filter.test((Byte)key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                    this.postRemoveHook();
                } else {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    public boolean removeIf(BytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || !filter.test(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                    this.postRemoveHook();
                } else {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                    this.postRemoveHook();
                } else {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean removeAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty() || c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block11: {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || !c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), key);
                                break block11;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                    this.postRemoveHook();
                } else {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof ByteCollection) {
            return this.retainAll(thisC, (ByteCollection)c);
        }
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block13: {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), key);
                                break block13;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                    this.postRemoveHook();
                } else {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    private boolean retainAll(@Nonnull HashByteSet thisC, @Nonnull ByteCollection c) {
        if (thisC == c) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        int firstDelayedRemoved = -1;
        byte delayedRemoved = 0;
        for (int i = tab.length - 1; i >= 0; --i) {
            block12: {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || c.contains(key)) continue;
                this.incrementModCount();
                ++mc;
                if (firstDelayedRemoved < 0) {
                    byte keyToShift;
                    int indexToRemove;
                    int indexToShift = indexToRemove = i;
                    int shiftDistance = 1;
                    while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                        if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                            if (indexToShift > indexToRemove) {
                                firstDelayedRemoved = i;
                                delayedRemoved = key;
                                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), key);
                                break block12;
                            }
                            if (indexToRemove == i) {
                                ++i;
                            }
                            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                            indexToRemove = indexToShift;
                            shiftDistance = 1;
                            continue;
                        }
                        ++shiftDistance;
                        if (indexToShift != 1 + i) continue;
                        throw new ConcurrentModificationException();
                    }
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                    this.postRemoveHook();
                } else {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), delayedRemoved);
                }
            }
            changed = true;
        }
        if (firstDelayedRemoved >= 0) {
            this.closeDelayedRemoved(firstDelayedRemoved, delayedRemoved);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    void closeDelayedRemoved(int firstDelayedRemoved, byte delayedRemoved) {
        byte free = this.freeValue;
        char[] tab = this.table;
        int capacityMask = tab.length - 1;
        for (int i = firstDelayedRemoved; i >= 0; --i) {
            byte keyToShift;
            int indexToRemove;
            char entry = tab[i];
            if ((byte)entry != delayedRemoved) continue;
            int indexToShift = indexToRemove = i;
            int shiftDistance = 1;
            while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                if (keyToShift != delayedRemoved && (LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                    U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                    indexToRemove = indexToShift;
                    shiftDistance = 1;
                    continue;
                }
                ++shiftDistance;
                if (indexToShift != 1 + i) continue;
                throw new ConcurrentModificationException();
            }
            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
            this.postRemoveHook();
        }
    }

    class NoRemovedCursor
    implements ByteCursor {
        char[] tab;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index;
        byte curKey;

        NoRemovedCursor(int mc) {
            byte free;
            this.expectedModCount = mc;
            this.tab = MutableParallelKVByteLHashGO.this.table;
            char[] tab = MutableParallelKVByteLHashGO.this.table;
            this.capacityMask = tab.length - 1;
            this.index = tab.length;
            this.curKey = free = (this.free = MutableParallelKVByteLHashGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (index != this.index || mc != MutableParallelKVByteLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableParallelKVByteLHashGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            byte curKey = this.curKey;
            byte free = this.free;
            if (curKey == free) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVByteLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.curKey = free;
            int index = this.index;
            char[] tab = this.tab;
            if (tab == MutableParallelKVByteLHashGO.this.table) {
                char entry;
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVByteLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != free) {
                    if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = index;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.index = ++index;
                            }
                        }
                        UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)indexToRemove << 1), free);
                MutableParallelKVByteLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVByteLHashGO.this.justRemove(curKey);
            }
        }
    }

    class NoRemovedIterator
    implements ByteIterator {
        char[] tab;
        final byte free;
        final int capacityMask;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableParallelKVByteLHashGO.this.table;
            char[] tab = MutableParallelKVByteLHashGO.this.table;
            this.capacityMask = tab.length - 1;
            byte free = this.free = MutableParallelKVByteLHashGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = key;
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableParallelKVByteLHashGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free) continue;
                        this.next = key;
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Byte)key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVByteLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key);
            }
            if (nextI != this.nextIndex || mc != MutableParallelKVByteLHashGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            int index = this.index;
            if (index < 0) throw new IllegalStateException();
            if (this.expectedModCount++ != MutableParallelKVByteLHashGO.this.modCount()) throw new ConcurrentModificationException();
            this.index = -1;
            char[] tab = this.tab;
            if (tab == MutableParallelKVByteLHashGO.this.table) {
                char entry;
                byte keyToShift;
                int indexToRemove;
                int capacityMask = this.capacityMask;
                MutableParallelKVByteLHashGO.this.incrementModCount();
                int indexToShift = indexToRemove = index;
                int shiftDistance = 1;
                while ((keyToShift = (byte)(entry = tab[indexToShift = indexToShift - 1 & capacityMask])) != this.free) {
                    if ((LHash.ParallelKVByteKeyMixing.mix((byte)keyToShift) - indexToShift & capacityMask) >= shiftDistance) {
                        if (this.tab == tab) {
                            if (indexToShift > indexToRemove) {
                                int slotsToCopy = this.nextIndex + 1;
                                if (slotsToCopy > 0) {
                                    this.tab = Arrays.copyOf(tab, slotsToCopy);
                                    if (indexToRemove < slotsToCopy) {
                                        UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)indexToRemove << 1), this.free);
                                    }
                                }
                            } else if (indexToRemove == index) {
                                this.nextIndex = index;
                                if (indexToShift < index - 1) {
                                    this.next = keyToShift;
                                }
                            }
                        }
                        UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)indexToRemove << 1), keyToShift);
                        indexToRemove = indexToShift;
                        shiftDistance = 1;
                        continue;
                    }
                    ++shiftDistance;
                    if (indexToShift != 1 + index) continue;
                    throw new ConcurrentModificationException();
                }
                UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)indexToRemove << 1), this.free);
                MutableParallelKVByteLHashGO.this.postRemoveHook();
                return;
            } else {
                MutableParallelKVByteLHashGO.this.justRemove(UnsafeConstants.U.getByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1)));
            }
        }
    }
}

