/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.Maths;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.HashWithoutRemovedSlots;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.LHashCapacities;

public abstract class MutableLHash
extends HashWithoutRemovedSlots
implements LHash {
    private HashConfigWrapper configWrapper;
    int size;
    private int maxSize;
    private int modCount = 0;

    static void verifyConfig(HashConfig config) {
        assert (config.getGrowthFactor() == 2.0);
    }

    public final HashConfigWrapper configWrapper() {
        return this.configWrapper;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final int modCount() {
        return this.modCount;
    }

    final void incrementModCount() {
        ++this.modCount;
    }

    final void copy(LHash hash) {
        this.configWrapper = hash.configWrapper();
        this.size = hash.size();
        int capacity = hash.capacity();
        this.maxSize = this.maxSize(capacity);
    }

    final void init(HashConfigWrapper configWrapper, int size) {
        MutableLHash.verifyConfig(configWrapper.config());
        this.configWrapper = configWrapper;
        this.size = 0;
        this.internalInit(this.targetCapacity(size));
    }

    private void internalInit(int capacity) {
        assert (Maths.isPowerOf2((int)capacity));
        this.maxSize = this.maxSize(capacity);
        this.allocateArrays(capacity);
    }

    private int maxSize(int capacity) {
        return !this.isMaxCapacity(capacity) ? this.configWrapper.maxSize(capacity) : capacity - 1;
    }

    abstract void allocateArrays(int var1);

    abstract void rehash(int var1);

    final void initForRehash(int newCapacity) {
        ++this.modCount;
        this.internalInit(newCapacity);
    }

    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    abstract void removeAt(int var1);

    public boolean shrink() {
        int newCapacity = this.targetCapacity(this.size);
        if (newCapacity < this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    private boolean tryRehashForExpansion(int newCapacity) {
        if (newCapacity > this.capacity()) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    public final boolean ensureCapacity(long minSize) {
        int intMinSize = (int)Math.min(minSize, Integer.MAX_VALUE);
        if (minSize < 0L) {
            throw new IllegalArgumentException("Min size should be positive, " + minSize + " given.");
        }
        return intMinSize > this.maxSize && this.tryRehashForExpansion(this.targetCapacity(intMinSize));
    }

    final void postRemoveHook() {
        --this.size;
    }

    final void postInsertHook() {
        int capacity;
        if (++this.size > this.maxSize && !this.isMaxCapacity(capacity = this.capacity())) {
            this.rehash(capacity << 1);
        }
    }

    boolean doubleSizedArrays() {
        return false;
    }

    private int targetCapacity(int size) {
        return LHashCapacities.capacity((HashConfigWrapper)this.configWrapper, (int)size, (boolean)this.doubleSizedArrays());
    }

    private boolean isMaxCapacity(int capacity) {
        return LHashCapacities.isMaxCapacity((int)capacity, (boolean)this.doubleSizedArrays());
    }
}

