/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.DoubleLHashFactory;
import com.koloboke.collect.impl.hash.ImmutableLHashDoubleSet;
import com.koloboke.collect.impl.hash.ImmutableLHashDoubleSetGO;
import com.koloboke.collect.impl.hash.MutableLHashDoubleSet;
import com.koloboke.collect.impl.hash.MutableLHashDoubleSetGO;
import com.koloboke.collect.impl.hash.SeparateKVDoubleLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashDoubleSet;
import com.koloboke.collect.impl.hash.UpdatableLHashDoubleSetGO;
import com.koloboke.collect.set.hash.HashDoubleSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class LHashDoubleSetFactorySO
extends DoubleLHashFactory
implements HashDoubleSetFactory {
    LHashDoubleSetFactorySO(HashConfig hashConf, int defaultExpectedSize) {
        super(hashConf, defaultExpectedSize);
    }

    MutableLHashDoubleSetGO uninitializedMutableSet() {
        return new MutableLHashDoubleSet();
    }

    UpdatableLHashDoubleSetGO uninitializedUpdatableSet() {
        return new UpdatableLHashDoubleSet();
    }

    ImmutableLHashDoubleSetGO uninitializedImmutableSet() {
        return new ImmutableLHashDoubleSet();
    }

    @Nonnull
    public MutableLHashDoubleSetGO newMutableSet(int expectedSize) {
        MutableLHashDoubleSet set = new MutableLHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableLHashDoubleSetGO newUpdatableSet(int expectedSize) {
        UpdatableLHashDoubleSet set = new UpdatableLHashDoubleSet();
        set.init(this.configWrapper, expectedSize);
        return set;
    }

    @Nonnull
    public UpdatableLHashDoubleSetGO newUpdatableSet(Iterable<Double> elements, int expectedSize) {
        if (elements instanceof DoubleCollection) {
            SeparateKVDoubleLHash hash;
            if (elements instanceof SeparateKVDoubleLHash && (hash = (SeparateKVDoubleLHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableLHashDoubleSet set = new UpdatableLHashDoubleSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableLHashDoubleSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableLHashDoubleSetGO set = this.newUpdatableSet(size);
        for (double e : elements) {
            set.add(e);
        }
        return set;
    }
}

