/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.DoubleCollection;
import com.koloboke.collect.DoubleCursor;
import com.koloboke.collect.DoubleIterator;
import com.koloboke.collect.impl.InternalDoubleCollectionOps;
import com.koloboke.collect.impl.hash.ImmutableSeparateKVDoubleLHashSO;
import com.koloboke.collect.set.DoubleSet;
import com.koloboke.collect.set.hash.HashDoubleSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class ImmutableSeparateKVDoubleLHashGO
extends ImmutableSeparateKVDoubleLHashSO {
    @Override
    @Nonnull
    public long[] keys() {
        return this.set;
    }

    public int capacity() {
        return this.set.length;
    }

    public void forEach(Consumer<? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept((Double)Double.longBitsToDouble(key));
        }
    }

    public void forEach(DoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            action.accept(Double.longBitsToDouble(key));
        }
    }

    public boolean forEachWhile(DoublePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || predicate.test(Double.longBitsToDouble(key))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.allContainingIn((InternalDoubleCollectionOps)c);
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(Double.longBitsToDouble(key))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    boolean allContainingIn(InternalDoubleCollectionOps c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(DoubleCollection c) {
        if (c instanceof InternalDoubleCollectionOps) {
            return this.reverseAddAllTo((InternalDoubleCollectionOps)c);
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= c.add(Double.longBitsToDouble(key));
        }
        return changed;
    }

    boolean reverseAddAllTo(InternalDoubleCollectionOps c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(DoubleSet s) {
        if (s instanceof InternalDoubleCollectionOps) {
            return this.reverseRemoveAllFrom((InternalDoubleCollectionOps)s);
        }
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= s.removeDouble(Double.longBitsToDouble(key));
        }
        return changed;
    }

    boolean reverseRemoveAllFrom(InternalDoubleCollectionOps s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            changed |= s.removeDouble(key);
        }
        return changed;
    }

    public DoubleIterator iterator() {
        return new NoRemovedIterator();
    }

    public DoubleCursor setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            result[resultIndex++] = Double.longBitsToDouble(key);
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            a[resultIndex++] = Double.longBitsToDouble(key);
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public double[] toDoubleArray() {
        int size = this.size();
        double[] result = new double[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            result[resultIndex++] = Double.longBitsToDouble(key);
        }
        return result;
    }

    @Nonnull
    public double[] toArray(double[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new double[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0.0;
            }
            return a;
        }
        int resultIndex = 0;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            a[resultIndex++] = Double.longBitsToDouble(key);
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0.0;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            hashCode += (int)(key ^ key >>> 32);
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] keys = this.set;
        for (int i = keys.length - 1; i >= 0; --i) {
            long key = keys[i];
            if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
            sb.append(' ').append(Double.longBitsToDouble(key)).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(long var1);

    public boolean removeIf(Predicate<? super Double> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(DoublePredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.retainAll(thisC, (DoubleCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull DoubleCollection c) {
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashDoubleSet thisC, @Nonnull InternalDoubleCollectionOps c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements DoubleCursor {
        final long[] keys;
        int index;
        long curKey;

        NoRemovedCursor() {
            this.keys = ImmutableSeparateKVDoubleLHashGO.this.set;
            this.index = this.keys.length;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public void forEachForward(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
        }

        public double elem() {
            long curKey = this.curKey;
            if (curKey != 0x7FFFFFFFFFFFFFFEL) {
                return Double.longBitsToDouble(curKey);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = 0x7FFFFFFFFFFFFFFEL;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements DoubleIterator {
        final long[] keys;
        int nextIndex;
        double next;

        NoRemovedIterator() {
            this.keys = ImmutableSeparateKVDoubleLHashGO.this.set;
            long[] keys = ImmutableSeparateKVDoubleLHashGO.this.set;
            int nextI = keys.length;
            while (--nextI >= 0) {
                long key = keys[nextI];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                this.next = Double.longBitsToDouble(key);
                break;
            }
            this.nextIndex = nextI;
        }

        public double nextDouble() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] keys = this.keys;
                double prev = this.next;
                while (--nextI >= 0) {
                    long key = keys[nextI];
                    if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                    this.next = Double.longBitsToDouble(key);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Double> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept((Double)Double.longBitsToDouble(key));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(DoubleConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] keys = this.keys;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long key = keys[i];
                if (key >= 0x7FFFFFFFFFFFFFFEL) continue;
                action.accept(Double.longBitsToDouble(key));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Double next() {
            return this.nextDouble();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

