/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.ImmutableLHash;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.SeparateKVCharLHash;

public abstract class ImmutableSeparateKVCharLHashSO
extends ImmutableLHash
implements SeparateKVCharLHash,
PrimitiveConstants,
UnsafeConstants {
    char freeValue;
    char[] set;

    void copy(SeparateKVCharLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = (char[])hash.keys().clone();
    }

    void move(SeparateKVCharLHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        this.set = hash.keys();
    }

    final void init(HashConfigWrapper configWrapper, int size, char freeValue) {
        this.freeValue = freeValue;
        super.init(configWrapper, size);
    }

    @Override
    public char freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return false;
    }

    @Override
    public char removedValue() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Object key) {
        return this.contains(((Character)key).charValue());
    }

    public boolean contains(char key) {
        return this.index(key) >= 0;
    }

    int index(char key) {
        char free = this.freeValue;
        if (key != free) {
            char[] keys = this.set;
            int capacityMask = keys.length - 1;
            int index = LHash.SeparateKVCharKeyMixing.mix((char)key) & capacityMask;
            char cur = keys[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            do {
                if ((cur = keys[index = index - 1 & capacityMask]) != key) continue;
                return index;
            } while (cur != free);
            return -1;
        }
        return -1;
    }
}

