/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.CommonObjIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.InternalObjIntMapOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashSeparateKVObjIntMapSO;
import com.koloboke.collect.impl.hash.ObjHash;
import com.koloboke.collect.impl.hash.SeparateKVObjIntQHash;
import com.koloboke.collect.map.ObjIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ObjIntPredicate;
import com.koloboke.function.ObjIntToIntFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;

public class ImmutableQHashSeparateKVObjIntMapGO<K>
extends ImmutableQHashSeparateKVObjIntMapSO<K> {
    @Override
    final void copy(SeparateKVObjIntQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVObjIntQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(Object key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Integer get(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int getInt(Object key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(Object key, int defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super K, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
    }

    @Override
    public void forEach(ObjIntConsumer<? super K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            action.accept(key, vals[i]);
        }
    }

    @Override
    public boolean forEachWhile(ObjIntPredicate<? super K> predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ObjIntCursor<K> cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonObjIntMapOps.containsAllEntries((InternalObjIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalObjIntMapOps<?> m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalObjIntMapOps<? super K> m) {
        if (this.isEmpty()) {
            return;
        }
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<K, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            hashCode += this.nullableKeyHashCode(key) ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        Object[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object key = keys[i];
            if (key == FREE) continue;
            sb.append(' ');
            sb.append(key != this ? key : "(this Map)");
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Integer put(K key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int put(K key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer putIfAbsent(K key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int putIfAbsent(K key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(K key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer compute(K key, BiFunction<? super K, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Integer computeNullKey(BiFunction<? super K, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(K key, ObjIntToIntFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    int computeNullKey(ObjIntToIntFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfAbsent(K key, Function<? super K, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    Integer computeIfAbsentNullKey(Function<? super K, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(K key, ToIntFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    int computeIfAbsentNullKey(ToIntFunction<? super K> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfPresent(K key, BiFunction<? super K, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(K key, ObjIntToIntFunction<? super K> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer merge(K key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    Integer mergeNullKey(Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(K key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    int mergeNullKey(int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(K key, int value) {
        throw new UnsupportedOperationException();
    }

    int addValueNullKey(int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(K key, int addition, int initialValue) {
        throw new UnsupportedOperationException();
    }

    int addValueWithInitialNullKey(int addition, int initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends K, ? extends Integer> m) {
        CommonObjIntMapOps.putAll((InternalObjIntMapOps)this, m);
    }

    public Integer replace(K key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int replace(K key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(K key, Integer oldValue, Integer newValue) {
        return this.replace(key, (int)oldValue, (int)newValue);
    }

    public boolean replace(K key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super K, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ObjIntToIntFunction<? super K> function) {
        throw new UnsupportedOperationException();
    }

    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    Integer removeNullKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(Object key) {
        throw new UnsupportedOperationException();
    }

    boolean justRemoveNullKey() {
        throw new UnsupportedOperationException();
    }

    public int removeAsInt(Object key) {
        throw new UnsupportedOperationException();
    }

    int removeAsIntNullKey() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(key, (Integer)value);
    }

    public boolean remove(Object key, int value) {
        throw new UnsupportedOperationException();
    }

    boolean removeEntryNullKey(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(ObjIntPredicate<? super K> filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ObjIntCursor<K> {
        final Object[] keys;
        final int[] vals;
        int index;
        Object curKey;
        int curValue;

        NoRemovedMapCursor() {
            this.keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(ObjIntConsumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public K key() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == ObjHash.FREE) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final Object[] keys;
        final int[] vals;
        int index;
        Object curKey;
        int curValue;

        NoRemovedValueCursor() {
            this.keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public int elem() {
            if (this.curKey != ObjHash.FREE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final Object[] keys;
        final int[] vals;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == ObjHash.FREE) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] keys = this.keys;
                int prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == ObjHash.FREE) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<K, Integer>> {
        final Object[] keys;
        final int[] vals;
        int index;
        Object curKey;
        int curValue;

        NoRemovedEntryCursor() {
            this.keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            this.curKey = ObjHash.FREE;
        }

        public void forEachForward(Consumer<? super Map.Entry<K, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            int[] vals = this.vals;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = ObjHash.FREE;
        }

        public Map.Entry<K, Integer> elem() {
            Object curKey = this.curKey;
            if (curKey != ObjHash.FREE) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            Object[] keys = this.keys;
            for (int i = this.index - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = ObjHash.FREE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<K, Integer>> {
        final Object[] keys;
        final int[] vals;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            int nextI = keys.length;
            while (--nextI >= 0) {
                Object key = keys[nextI];
                if (key == ObjHash.FREE) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<K, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            Object[] keys = this.keys;
            int[] vals = this.vals;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<K, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                Object[] keys = this.keys;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    Object key = keys[nextI];
                    if (key == ObjHash.FREE) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVObjIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableQHashSeparateKVObjIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept((Integer)vals[i]);
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                changed |= s.removeInt(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == ObjHash.FREE) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableQHashSeparateKVObjIntMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashSeparateKVObjIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ObjIntEntry {
        private K key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(K key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ObjIntEntry {
        private final K key;
        private final int value;

        ImmutableEntry(K key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class ObjIntEntry
    extends AbstractEntry<K, Integer> {
        ObjIntEntry() {
        }

        abstract K key();

        public final K getKey() {
            return this.key();
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                Object k2 = e2.getKey();
                int v2 = (Integer)e2.getValue();
                return ImmutableQHashSeparateKVObjIntMapGO.this.nullableKeyEquals(k2, this.key()) && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.nullableKeyHashCode(this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<K, Integer>>
    implements HashObjSet<Map.Entry<K, Integer>>,
    InternalObjCollectionOps<Map.Entry<K, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<K, Integer>> equivalence() {
            return Equivalence.entryEquivalence(ImmutableQHashSeparateKVObjIntMapGO.this.keyEquivalence(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVObjIntMapGO.this.containsEntry(e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<K, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                action.accept((Map.Entry)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<K, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || predicate.test((Map.Entry)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<K, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<K, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<K, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            Object[] keys = ImmutableQHashSeparateKVObjIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVObjIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object key = keys[i];
                if (key == ObjHash.FREE) continue;
                sb.append(' ');
                sb.append(key != this ? key : "(this Collection)");
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVObjIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                int value = (Integer)e.getValue();
                return ImmutableQHashSeparateKVObjIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<K, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

