/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteIntMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.ImmutableQHashSeparateKVByteIntMapSO;
import com.koloboke.collect.impl.hash.SeparateKVByteIntQHash;
import com.koloboke.collect.map.ByteIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteIntConsumer;
import com.koloboke.function.ByteIntPredicate;
import com.koloboke.function.ByteIntToIntFunction;
import com.koloboke.function.ByteToIntFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashSeparateKVByteIntMapGO
extends ImmutableQHashSeparateKVByteIntMapSO {
    @Override
    final void copy(SeparateKVByteIntQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVByteIntQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(byte key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Integer get(Object key) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return this.values[index];
        }
        return null;
    }

    public int get(byte key) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return this.defaultValue();
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        int index = this.index((Byte)key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public int getOrDefault(byte key, int defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept((Byte)key, (Integer)vals[i]);
        }
    }

    public void forEach(ByteIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            action.accept(key, vals[i]);
        }
    }

    public boolean forEachWhile(ByteIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || predicate.test(key, vals[i])) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ByteIntCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteIntMapOps.containsAllEntries((InternalByteIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free || m.containsEntry(key, vals[i])) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            m.justPut(key, vals[i]);
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            hashCode += key ^ vals[i];
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        byte[] keys = this.set;
        int[] vals = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            byte key = keys[i];
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append(vals[i]);
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Integer put(Byte key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int put(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer putIfAbsent(Byte key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int putIfAbsent(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public Integer compute(Byte key, BiFunction<? super Byte, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int compute(byte key, ByteIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfAbsent(Byte key, Function<? super Byte, ? extends Integer> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfAbsent(byte key, ByteToIntFunction mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer computeIfPresent(Byte key, BiFunction<? super Byte, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int computeIfPresent(byte key, ByteIntToIntFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Integer merge(Byte key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int merge(byte key, int value, IntBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public int addValue(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public int addValue(byte key, int addition, int initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Integer> m) {
        CommonByteIntMapOps.putAll((InternalByteIntMapOps)this, m);
    }

    public Integer replace(Byte key, Integer value) {
        throw new UnsupportedOperationException();
    }

    public int replace(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Byte key, Integer oldValue, Integer newValue) {
        return this.replace((byte)key, (int)oldValue, (int)newValue);
    }

    public boolean replace(byte key, int oldValue, int newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Byte, ? super Integer, ? extends Integer> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ByteIntToIntFunction function) {
        throw new UnsupportedOperationException();
    }

    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public int remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Integer)value);
    }

    public boolean remove(byte key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteIntCursor {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int index;
        byte curKey;
        int curValue;

        NoRemovedMapCursor() {
            byte free;
            this.keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue);
        }

        public void forEachForward(ByteIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept(key, vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            this.vals[this.index] = value;
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int index;
        byte curKey;
        int curValue;

        NoRemovedValueCursor() {
            byte free;
            this.keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue);
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public int elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int nextIndex;
        int next;

        NoRemovedValueIterator() {
            this.keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            byte free = this.free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = vals[nextI];
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                int prev = this.next;
                while (--nextI >= 0) {
                    if (keys[nextI] == free) continue;
                    this.next = this.vals[nextI];
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Integer>> {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int index;
        byte curKey;
        int curValue;

        NoRemovedEntryCursor() {
            byte free;
            this.keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            this.index = this.keys.length;
            this.vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            this.curKey = free = (this.free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Integer> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            byte[] keys = this.keys;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = this.vals[i];
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Integer>> {
        final byte[] keys;
        final int[] vals;
        final byte free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            this.vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            byte free = this.free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                byte key = keys[nextI];
                if (key == free) continue;
                this.next = new ImmutableEntry(key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] keys = this.keys;
            int[] vals = this.vals;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Integer> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                byte[] keys = this.keys;
                byte free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    byte key = keys[nextI];
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, this.vals[nextI]);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashSeparateKVByteIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return ImmutableQHashSeparateKVByteIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept((Integer)vals[i]);
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(vals[i]);
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || predicate.test(vals[i])) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free || c.contains(vals[i])) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= c.add(vals[i]);
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                changed |= s.removeInt(vals[i]);
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public IntCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                result[resultIndex++] = vals[i];
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                a[resultIndex++] = vals[i];
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                sb.append(' ').append(vals[i]).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return ImmutableQHashSeparateKVByteIntMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashSeparateKVByteIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteIntEntry {
        private byte key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ByteIntEntry {
        private final byte key;
        private final int value;

        ImmutableEntry(byte key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    abstract class ByteIntEntry
    extends AbstractEntry<Byte, Integer> {
        ByteIntEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Integer>>
    implements HashObjSet<Map.Entry<Byte, Integer>>,
    InternalObjCollectionOps<Map.Entry<Byte, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashSeparateKVByteIntMapGO.this.containsEntry((Byte)e.getKey(), (Integer)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, vals[i]);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Integer>)((Object)new ImmutableEntry(key, vals[i])));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || predicate.test((Map.Entry<Byte, Integer>)((Object)new ImmutableEntry(key, vals[i])))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Integer>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Integer>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, vals[i]));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, vals[i]));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableQHashSeparateKVByteIntMapGO.this.freeValue;
            byte[] keys = ImmutableQHashSeparateKVByteIntMapGO.this.set;
            int[] vals = ImmutableQHashSeparateKVByteIntMapGO.this.values;
            for (int i = keys.length - 1; i >= 0; --i) {
                byte key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(vals[i]);
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashSeparateKVByteIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                int value = (Integer)e.getValue();
                return ImmutableQHashSeparateKVByteIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

