/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteByteMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.ImmutableQHashParallelKVByteByteMapSO;
import com.koloboke.collect.impl.hash.ParallelKVByteByteQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.ByteByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteByteConsumer;
import com.koloboke.function.ByteBytePredicate;
import com.koloboke.function.ByteByteToByteFunction;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.ByteUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ImmutableQHashParallelKVByteByteMapGO
extends ImmutableQHashParallelKVByteByteMapSO {
    final void copy(ParallelKVByteByteQHash hash) {
        int hashMC = hash.modCount();
        super.copy(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVByteByteQHash hash) {
        int hashMC = hash.modCount();
        super.move(hash);
        if (hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return (byte)(entry >>> 8) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return (byte)(entry >>> 8) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    public Byte get(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public byte get(byte key) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue)) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public byte getOrDefault(byte key, byte defaultValue) {
        byte free = this.freeValue;
        if (key != free) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept((Byte)key, (Byte)((byte)(entry >>> 8)));
        }
    }

    public void forEach(ByteByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            action.accept(key, (byte)(entry >>> 8));
        }
    }

    public boolean forEachWhile(ByteBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || predicate.test(key, (byte)(entry >>> 8))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    @Nonnull
    public ByteByteCursor cursor() {
        return new NoRemovedMapCursor();
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteByteMapOps.containsAllEntries((InternalByteByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free || m.containsEntry(key, (byte)(entry >>> 8))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            m.justPut(key, (byte)(entry >>> 8));
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            hashCode += key ^ (byte)(entry >>> 8);
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        byte free = this.freeValue;
        char[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            char entry = tab[i];
            byte key = (byte)entry;
            if (key == free) continue;
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append((byte)(entry >>> 8));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    public Byte put(Byte key, Byte value) {
        throw new UnsupportedOperationException();
    }

    public byte put(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public Byte putIfAbsent(Byte key, Byte value) {
        throw new UnsupportedOperationException();
    }

    public byte putIfAbsent(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public void justPut(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public Byte compute(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte compute(byte key, ByteByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Byte computeIfAbsent(Byte key, Function<? super Byte, ? extends Byte> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfAbsent(byte key, ByteUnaryOperator mappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Byte computeIfPresent(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte computeIfPresent(byte key, ByteByteToByteFunction remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public Byte merge(Byte key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte merge(byte key, byte value, ByteBinaryOperator remappingFunction) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte addValue(byte key, byte addition, byte initialValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Byte> m) {
        CommonByteByteMapOps.putAll((InternalByteByteMapOps)this, m);
    }

    public Byte replace(Byte key, Byte value) {
        throw new UnsupportedOperationException();
    }

    public byte replace(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(Byte key, Byte oldValue, Byte newValue) {
        return this.replace((byte)key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(byte key, byte oldValue, byte newValue) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(BiFunction<? super Byte, ? super Byte, ? extends Byte> function) {
        throw new UnsupportedOperationException();
    }

    public void replaceAll(ByteByteToByteFunction function) {
        throw new UnsupportedOperationException();
    }

    public Byte remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(byte key) {
        throw new UnsupportedOperationException();
    }

    public byte remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Byte)value);
    }

    public boolean remove(byte key, byte value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(ByteBytePredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements ByteByteCursor {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedMapCursor() {
            byte free;
            this.tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey == this.free) {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), value);
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (byte)(entry >>> 8);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedValueCursor() {
            byte free;
            this.tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (byte)(entry >>> 8);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        int nextIndex;
        byte next;

        NoRemovedValueIterator() {
            this.tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                if ((byte)entry == free) continue;
                this.next = (byte)(entry >>> 8);
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] tab = this.tab;
                byte free = this.free;
                byte prev = this.next;
                while (--nextI >= 0) {
                    char entry = tab[nextI];
                    if ((byte)entry == free) continue;
                    this.next = (byte)(entry >>> 8);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedEntryCursor() {
            byte free;
            this.tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = free = (this.free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue);
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new ImmutableEntry(key, (byte)(entry >>> 8))));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Byte> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new ImmutableEntry(curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = this.index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                this.index = i;
                this.curKey = key;
                this.curValue = (byte)(entry >>> 8);
                return true;
            }
            this.curKey = free;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        int nextIndex;
        ImmutableEntry next;

        NoRemovedEntryIterator() {
            this.tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = new ImmutableEntry(key, (byte)(entry >>> 8));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new ImmutableEntry(key, (byte)(entry >>> 8))));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Byte> next() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                char[] tab = this.tab;
                byte free = this.free;
                ImmutableEntry prev = this.next;
                while (--nextI >= 0) {
                    char entry = tab[nextI];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.next = new ImmutableEntry(key, (byte)(entry >>> 8));
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return ImmutableQHashParallelKVByteByteMapGO.this.size();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVByteByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return ImmutableQHashParallelKVByteByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return ImmutableQHashParallelKVByteByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || predicate.test((byte)(entry >>> 8))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= c.add((byte)(entry >>> 8));
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                changed |= s.removeByte((byte)(entry >>> 8));
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            return new NoRemovedValueIterator();
        }

        @Nonnull
        public ByteCursor cursor() {
            return new NoRemovedValueCursor();
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                result[resultIndex++] = (byte)(entry >>> 8);
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                a[resultIndex++] = (byte)(entry >>> 8);
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                sb.append(' ').append((byte)(entry >>> 8)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return ImmutableQHashParallelKVByteByteMapGO.this.removeValue(v);
        }

        public void clear() {
            ImmutableQHashParallelKVByteByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(BytePredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends ByteByteEntry {
        private byte key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    private class ImmutableEntry
    extends ByteByteEntry {
        private final byte key;
        private final byte value;

        ImmutableEntry(byte key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    abstract class ByteByteEntry
    extends AbstractEntry<Byte, Byte> {
        ByteByteEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Byte>>
    implements HashObjSet<Map.Entry<Byte, Byte>>,
    InternalObjCollectionOps<Map.Entry<Byte, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return ImmutableQHashParallelKVByteByteMapGO.this.hashConfig();
        }

        public int size() {
            return ImmutableQHashParallelKVByteByteMapGO.this.size;
        }

        public double currentLoad() {
            return ImmutableQHashParallelKVByteByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return ImmutableQHashParallelKVByteByteMapGO.this.containsEntry((Byte)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                result[resultIndex++] = new ImmutableEntry(key, (byte)(entry >>> 8));
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                a[resultIndex++] = new ImmutableEntry(key, (byte)(entry >>> 8));
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new ImmutableEntry(key, (byte)(entry >>> 8))));
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || predicate.test((Map.Entry<Byte, Byte>)((Object)new ImmutableEntry(key, (byte)(entry >>> 8))))) continue;
                terminated = true;
                break;
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Byte>> iterator() {
            return new NoRemovedEntryIterator();
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Byte>> cursor() {
            return new NoRemovedEntryCursor();
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                containsAll = false;
                break;
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= s.remove((Object)e.with(key, (byte)(entry >>> 8)));
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                changed |= c.add((Object)new ImmutableEntry(key, (byte)(entry >>> 8)));
            }
            return changed;
        }

        public int hashCode() {
            return ImmutableQHashParallelKVByteByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            byte free = ImmutableQHashParallelKVByteByteMapGO.this.freeValue;
            char[] tab = ImmutableQHashParallelKVByteByteMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((byte)(entry >>> 8));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return ImmutableQHashParallelKVByteByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                byte value = (Byte)e.getValue();
                return ImmutableQHashParallelKVByteByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

