/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalCharIntMapOps;
import com.koloboke.collect.map.CharIntMap;
import com.koloboke.function.CharIntConsumer;
import com.koloboke.function.CharIntPredicate;
import java.util.Map;

public final class CommonCharIntMapOps {
    public static boolean containsAllEntries(final InternalCharIntMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof CharIntMap) {
            CharIntMap m2 = (CharIntMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalCharIntMapOps) {
                return ((InternalCharIntMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new CharIntPredicate(){

                public boolean test(char a, int b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry(((Character)e.getKey()).charValue(), (Integer)e.getValue())) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalCharIntMapOps map, Map<? extends Character, ? extends Integer> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof CharIntMap) {
            if (another instanceof InternalCharIntMapOps) {
                ((InternalCharIntMapOps)another).reversePutAllTo(map);
            } else {
                ((CharIntMap)another).forEach(new CharIntConsumer(){

                    public void accept(char key, int value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Character, ? extends Integer> e : another.entrySet()) {
                map.justPut(e.getKey().charValue(), e.getValue());
            }
        }
    }

    private CommonCharIntMapOps() {
    }
}

