/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketException;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketFactory;
import org.newsclub.net.unix.AFSocketImpl;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.AFVSOCKSocketImplExtensions;
import org.newsclub.net.unix.vsock.AFVSOCKSocketChannel;
import org.newsclub.net.unix.vsock.AFVSOCKSocketExtensions;
import org.newsclub.net.unix.vsock.AFVSOCKSocketFactory;
import org.newsclub.net.unix.vsock.AFVSOCKSocketImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFVSOCKSocket
extends AFSocket<AFVSOCKSocketAddress>
implements AFVSOCKSocketExtensions {
    private static AFVSOCKSocketImplExtensions staticExtensions = null;

    AFVSOCKSocket(FileDescriptor fdObj, AFSocketFactory<AFVSOCKSocketAddress> factory) throws SocketException {
        super((AFSocketImpl)new AFVSOCKSocketImpl(fdObj), factory);
    }

    private static synchronized AFVSOCKSocketImplExtensions getStaticImplExtensions() throws IOException {
        if (staticExtensions == null) {
            try (AFVSOCKSocket socket = new AFVSOCKSocket(null, null);){
                staticExtensions = (AFVSOCKSocketImplExtensions)socket.getImplExtensions();
            }
        }
        return staticExtensions;
    }

    public static boolean isSupported() {
        return AFSocket.isSupported() && AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_VSOCK);
    }

    protected AFVSOCKSocketChannel newChannel() {
        return new AFVSOCKSocketChannel(this);
    }

    public static AFVSOCKSocket newInstance() throws IOException {
        return (AFVSOCKSocket)AFSocket.newInstance(AFVSOCKSocket::new, (AFSocketFactory)null);
    }

    static AFVSOCKSocket newInstance(AFVSOCKSocketFactory factory) throws SocketException {
        return (AFVSOCKSocket)AFSocket.newInstance(AFVSOCKSocket::new, (AFSocketFactory)factory);
    }

    public static AFVSOCKSocket newStrictInstance() throws IOException {
        return (AFVSOCKSocket)AFSocket.newInstance(AFVSOCKSocket::new, (AFSocketFactory)null);
    }

    public static AFVSOCKSocket connectTo(AFVSOCKSocketAddress addr) throws IOException {
        return (AFVSOCKSocket)AFSocket.connectTo(AFVSOCKSocket::new, (AFSocketAddress)addr);
    }

    public AFVSOCKSocketChannel getChannel() {
        return (AFVSOCKSocketChannel)super.getChannel();
    }

    public static int getLocalCID() throws IOException {
        return AFVSOCKSocket.getStaticImplExtensions().getLocalCID();
    }

    public static void main(String[] args) {
        System.out.print(AFVSOCKSocket.class.getName() + ".isSupported(): ");
        System.out.flush();
        System.out.println(AFVSOCKSocket.isSupported());
    }
}

