/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.vsock;

import java.io.IOException;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.newsclub.net.unix.AFInputStream;
import org.newsclub.net.unix.AFOutputStream;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketConnector;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFVSOCKSocketAddress;
import org.newsclub.net.unix.AddressUnavailableSocketException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFVSOCKProxySocketConnector
implements AFSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> {
    private static final AFSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> DIRECT_CONNECTOR = new AFSocketConnector<AFVSOCKSocketAddress, AFSocketAddress>(){

        public AFSocket<? extends AFSocketAddress> connect(AFVSOCKSocketAddress addr) throws IOException {
            return addr.newConnectedSocket();
        }
    };
    private static final Pattern PAT_OK = Pattern.compile("OK ([0-9]+)");
    private static final byte[] OK = new byte[]{79, 75, 32};
    private final AFUNIXSocketAddress connectorAddress;
    private final int allowedCID;

    private AFVSOCKProxySocketConnector(AFUNIXSocketAddress connectorAddress, int allowedCID) {
        this.connectorAddress = connectorAddress;
        this.allowedCID = allowedCID;
    }

    public static AFSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> openFirecrackerStyleConnector(AFUNIXSocketAddress connectorAddress, int allowedCID) {
        return new AFVSOCKProxySocketConnector(connectorAddress, allowedCID);
    }

    public static AFSocketConnector<AFVSOCKSocketAddress, AFSocketAddress> openDirectConnector() {
        return DIRECT_CONNECTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFSocket<?> connect(AFVSOCKSocketAddress vsockAddress) throws IOException {
        int cid = vsockAddress.getVSOCKCID();
        if (cid != this.allowedCID && cid != -1 && this.allowedCID != -1) {
            throw new AddressUnavailableSocketException("Connector does not cover CID " + cid);
        }
        AFUNIXSocket sock = this.connectorAddress.newConnectedSocket();
        AFInputStream in = sock.getInputStream();
        AFOutputStream out = sock.getOutputStream();
        boolean success = false;
        try {
            Matcher m;
            int b;
            int i;
            String connectLine = "CONNECT " + vsockAddress.getVSOCKPort() + "\n";
            out.write(connectLine.getBytes(StandardCharsets.ISO_8859_1));
            byte[] buf = new byte[16];
            for (i = 0; (b = in.read()) != -1 && b != 10 && i < buf.length; ++i) {
                buf[i] = (byte)b;
                if (i < 3 && OK[i] != b) break;
            }
            if (b == 10 && i > 3 && (m = PAT_OK.matcher(new String(buf, 0, i, StandardCharsets.ISO_8859_1))).matches()) {
                Integer.parseInt(m.group(1));
                success = true;
            }
        }
        finally {
            if (!success) {
                sock.close();
                throw new SocketException("Unexpected response from proxy socket");
            }
        }
        return sock;
    }
}

