/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.function.Function;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.newsclub.net.unix.ssl.BuilderSSLServerSocketFactory;
import org.newsclub.net.unix.ssl.BuilderSSLSocketFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class BuilderSSLContext
extends SSLContext {
    BuilderSSLContext(boolean clientMode, SSLContext context, Function<SSLParameters, SSLParameters> parametersFunction, SocketFactory socketFactory) {
        super(new ConfiguredSSLContextSpi(clientMode, context, parametersFunction, socketFactory), context.getProvider(), context.getProtocol());
    }

    static void initContext(SSLContext context, KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        try {
            context.init(km, tm, sr);
        }
        catch (IllegalStateException e) {
            if (sr == null && e.getMessage().contains("SecureRandom not available")) {
                try {
                    sr = SecureRandom.getInstanceStrong();
                }
                catch (NoSuchAlgorithmException e1) {
                    e.addSuppressed(e1);
                    throw e;
                }
                context.init(km, tm, sr);
            }
            throw e;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ConfiguredSSLContextSpi
    extends SSLContextSpi {
        private final SSLSocketFactory socketFactory;
        private final SSLServerSocketFactory serverSocketFactory;
        private final SSLContext context;
        private final SSLParameters params;
        private final boolean clientMode;

        private ConfiguredSSLContextSpi(boolean clientMode, SSLContext context, Function<SSLParameters, SSLParameters> parametersFunction, SocketFactory socketFactory) {
            this.clientMode = clientMode;
            this.context = context;
            SSLParameters p = context.getDefaultSSLParameters();
            if (parametersFunction != null) {
                p = parametersFunction.apply(p);
            }
            this.params = p;
            this.socketFactory = new BuilderSSLSocketFactory(clientMode, context, context.getSocketFactory(), p, socketFactory);
            this.serverSocketFactory = new BuilderSSLServerSocketFactory(context.getServerSocketFactory(), p);
        }

        @Override
        protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
            BuilderSSLContext.initContext(this.context, km, tm, sr);
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            return this.socketFactory;
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            return this.serverSocketFactory;
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            return this.init(this.context.createSSLEngine());
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String host, int port) {
            return this.init(this.context.createSSLEngine(host, port));
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            return this.context.getServerSessionContext();
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            return this.context.getClientSessionContext();
        }

        private SSLEngine init(SSLEngine engine) {
            engine.setEnabledProtocols(this.params.getProtocols());
            engine.setEnabledCipherSuites(this.params.getCipherSuites());
            engine.setUseClientMode(this.clientMode);
            return engine;
        }
    }
}

