/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;
import org.newsclub.net.unix.ssl.FilterSSLSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class BuilderSSLSocket
extends FilterSSLSocket {
    private final Socket underlyingSocket;
    private final boolean doCloseUnderlyingSocket;

    BuilderSSLSocket(SSLSocket socket, Socket underlyingSocket, boolean doCloseUnderlyingSocket) {
        super(socket);
        this.underlyingSocket = underlyingSocket;
        this.doCloseUnderlyingSocket = doCloseUnderlyingSocket;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FilterInputStream(super.getInputStream()){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FilterOutputStream(super.getOutputStream()){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                catch (SocketException socketException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public synchronized void close() throws IOException {
        block4: {
            try {
                super.close();
            }
            catch (SocketException e) {
                Socket s;
                if (!this.doCloseUnderlyingSocket || (s = this.underlyingSocket) == null) break block4;
                try {
                    s.close();
                }
                catch (IOException e1) {
                    e1.addSuppressed(e);
                    throw e1;
                }
            }
        }
    }
}

