/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class FilterX509TrustManager
implements X509TrustManager {
    private final X509TrustManager wrapped;

    protected FilterX509TrustManager(X509TrustManager wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public final void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.wrapped.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.onCertificateException(true, e, chain, authType);
            return;
        }
        this.onCertificateTrusted(true, chain, authType);
    }

    @Override
    public final void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            this.onCertificateException(false, e, chain, authType);
            return;
        }
        this.onCertificateTrusted(false, chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.wrapped.getAcceptedIssuers();
    }

    protected abstract void onCertificateException(boolean var1, CertificateException var2, X509Certificate[] var3, String var4) throws CertificateException;

    protected abstract void onCertificateTrusted(boolean var1, X509Certificate[] var2, String var3) throws CertificateException;
}

