/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class BuilderSSLServerSocketFactory
extends SSLServerSocketFactory {
    private final SSLServerSocketFactory factory;
    private final SSLParameters defaultParams;

    BuilderSSLServerSocketFactory(SSLServerSocketFactory factory, SSLParameters defaultParams) {
        this.factory = factory;
        this.defaultParams = defaultParams;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultParams.getCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    private SSLServerSocket init(SSLServerSocket socket) {
        socket.setSSLParameters(this.defaultParams);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.init((SSLServerSocket)this.factory.createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.init((SSLServerSocket)this.factory.createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.init((SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress));
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.init((SSLServerSocket)this.factory.createServerSocket());
    }
}

