/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.newsclub.net.unix.ssl.CallbackSNIMatcher;
import org.newsclub.net.unix.ssl.SSLParametersUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SNIHostnameCapture {
    public static final SNIMatcher ACCEPT_ANY_HOSTNAME = new SNIMatcher(0){

        @Override
        public boolean matches(SNIServerName serverName) {
            return serverName.getType() == 0;
        }
    };
    private final CompletableFuture<String> hostnameFuture = new CompletableFuture();
    private final Supplier<String> defaultHostnameSupplier;

    private SNIHostnameCapture(Supplier<String> defaultHostnameSupplier) {
        this.defaultHostnameSupplier = defaultHostnameSupplier;
    }

    public static SNIHostnameCapture configure(SSLSocket sslSocket, SNIMatcher hostnameMatcher) {
        return SNIHostnameCapture.configure(sslSocket, hostnameMatcher, null);
    }

    public static SNIHostnameCapture configure(SSLSocket sslSocket, SNIMatcher hostnameMatcher, Supplier<String> defaultHostnameSupplier) {
        SNIHostnameCapture capture = new SNIHostnameCapture(defaultHostnameSupplier == null ? () -> null : defaultHostnameSupplier);
        sslSocket.addHandshakeCompletedListener(e -> capture.set(null));
        SSLParametersUtil.setSNIMatcher(sslSocket, new CallbackSNIMatcher(hostnameMatcher, (name, matches) -> {
            if (matches && name instanceof SNIHostName) {
                capture.set(((SNIHostName)name).getAsciiName());
            }
        }));
        return capture;
    }

    private void set(String hostname) {
        this.hostnameFuture.complete(hostname);
    }

    public boolean isComplete(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.hostnameFuture.get(timeout, unit);
            return this.hostnameFuture.isDone();
        }
        catch (ExecutionException | TimeoutException e) {
            return false;
        }
    }

    public boolean isComplete() {
        return this.hostnameFuture.isDone();
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public String getHostname() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Handshake not yet complete");
        }
        String hn = this.hostnameFuture.getNow(null);
        if (hn == null) {
            return this.defaultHostnameSupplier.get();
        }
        return hn;
    }

    String getHostnameFromSSLSession(SSLSocket socket, Consumer<UnsupportedOperationException> usoCallback) {
        block6: {
            SSLSession session = socket.getSession();
            if (session instanceof ExtendedSSLSession) {
                ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                try {
                    List<SNIServerName> list = extSession.getRequestedServerNames();
                    if (list != null) {
                        for (SNIServerName sn : list) {
                            if (sn instanceof SNIHostName) {
                                return ((SNIHostName)sn).getAsciiName();
                            }
                            if (sn.getType() != 0) continue;
                            return new SNIHostName(sn.getEncoded()).getAsciiName();
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (usoCallback == null) break block6;
                    usoCallback.accept(e);
                }
            }
        }
        return this.defaultHostnameSupplier.get();
    }
}

