/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.ssl;

import com.kohlschutter.annotations.compiletime.ExcludeFromCodeCoverageGeneratedReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SSLParametersUtil {
    @ExcludeFromCodeCoverageGeneratedReport
    private SSLParametersUtil() {
        throw new IllegalStateException("No instances");
    }

    public static void disableProtocols(SSLParameters params, String ... protocols) {
        SSLParametersUtil.removeElements(params::getProtocols, params::setProtocols, protocols);
    }

    public static void disableCipherSuites(SSLParameters params, String ... cipherSuites) {
        SSLParametersUtil.removeElements(params::getCipherSuites, params::setCipherSuites, cipherSuites);
    }

    public static void setSNIMatcher(SSLSocket s, SNIMatcher matcher) {
        SSLParameters p = s.getSSLParameters();
        p.setSNIMatchers(Collections.singleton(matcher));
        s.setSSLParameters(p);
    }

    public static void setSNIServerName(SSLSocket s, SNIServerName name) {
        SSLParameters p = s.getSSLParameters();
        p.setServerNames(Collections.singletonList(name));
        s.setSSLParameters(p);
    }

    private static void removeElements(Supplier<String[]> getter, Consumer<String[]> setter, String ... protocols) {
        HashSet<String> protos = new HashSet<String>(Arrays.asList(getter.get()));
        protos.removeAll(Arrays.asList(protocols));
        setter.accept(protos.toArray(new String[0]));
    }
}

