/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.server;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.annotations.compiletime.SuppressLint;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SocketServer<A extends SocketAddress, S extends Socket, V extends ServerSocket> {
    private static final ScheduledExecutorService TIMEOUTS = Executors.newScheduledThreadPool(1);
    private final @NonNull A listenAddress;
    private int maxConcurrentConnections = Runtime.getRuntime().availableProcessors();
    private int serverTimeout = 0;
    private int socketTimeout = (int)TimeUnit.SECONDS.toMillis(60L);
    private int serverBusyTimeout = (int)TimeUnit.SECONDS.toMillis(1L);
    private Thread listenThread = null;
    private V serverSocket;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final Object connectionsMonitor = new Object();
    private ForkJoinPool connectionPool;
    private ScheduledFuture<IOException> timeoutFuture;
    private final V reuseSocket;

    public SocketServer(V serverSocket) {
        this(((ServerSocket)Objects.requireNonNull(serverSocket)).getLocalSocketAddress(), serverSocket);
    }

    public SocketServer(A listenAddress) {
        this(listenAddress, null);
    }

    private SocketServer(A listenAddress, V preboundSocket) {
        Objects.requireNonNull(listenAddress, "listenAddress");
        this.reuseSocket = preboundSocket;
        this.listenAddress = listenAddress;
    }

    public int getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public void setMaxConcurrentConnections(int maxConcurrentConnections) {
        if (this.isRunning()) {
            throw new IllegalStateException("Already configured");
        }
        this.maxConcurrentConnections = maxConcurrentConnections;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setServerTimeout(int timeout) {
        if (this.isRunning()) {
            throw new IllegalStateException("Already configured");
        }
        this.serverTimeout = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getServerBusyTimeout() {
        return this.serverBusyTimeout;
    }

    public void setServerBusyTimeout(int timeout) {
        this.serverBusyTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            return this.listenThread != null && this.listenThread.isAlive();
        }
    }

    public boolean isReady() {
        return this.ready.get() && !this.stopRequested.get() && this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (this.isRunning()) {
                return;
            }
            if (this.connectionPool == null) {
                this.connectionPool = new ForkJoinPool(this.maxConcurrentConnections, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
            }
            Thread t = new Thread(this.toString() + " listening thread"){

                @Override
                public void run() {
                    try {
                        SocketServer.this.listen();
                    }
                    catch (Exception e) {
                        SocketServer.this.onListenException(e);
                    }
                    catch (Throwable e) {
                        SocketServer.this.onListenException(e);
                    }
                }
            };
            t.start();
            this.listenThread = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAndWaitToBecomeReady() throws InterruptedException {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.start();
            while (!this.ready.get() && !this.stopRequested.get()) {
                this.wait(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startAndWaitToBecomeReady(long duration, TimeUnit unit) throws InterruptedException {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.start();
            long timeStart = System.currentTimeMillis();
            while (duration > 0L) {
                if (this.isReady()) {
                    return true;
                }
                this.wait(unit.toMillis(duration));
                duration -= System.currentTimeMillis() - timeStart;
            }
            return this.isReady();
        }
    }

    protected abstract V newServerSocket() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen() throws IOException {
        ServerSocket server = null;
        try {
            SocketServer socketServer = this;
            synchronized (socketServer) {
                server = this.reuseSocket != null ? (ServerSocket)this.reuseSocket : null;
            }
            if (server == null) {
                server = (ServerSocket)this.newServerSocket();
            }
            socketServer = this;
            synchronized (socketServer) {
                if (this.serverSocket != null) {
                    throw new IllegalStateException("The server is already listening");
                }
                this.serverSocket = server;
            }
            this.onServerStarting();
            if (!server.isBound()) {
                server.bind((SocketAddress)this.listenAddress);
                this.onServerBound(this.listenAddress);
            }
            server.setSoTimeout(this.serverTimeout);
            this.acceptLoop(server);
        }
        catch (SocketException e) {
            this.onSocketExceptionDuringAccept(e);
        }
        finally {
            this.stop();
            this.onServerStopped(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    @SuppressLint(value={"RESOURCE_LEAK"})
    private void acceptLoop(V server) throws IOException {
        long busyStartTime = 0L;
        while (!this.stopRequested.get() && !Thread.interrupted()) {
            try {
                Socket socket;
                Object object;
                while (!this.stopRequested.get() && this.connectionPool.getActiveThreadCount() >= this.maxConcurrentConnections) {
                    if (busyStartTime == 0L) {
                        busyStartTime = System.currentTimeMillis();
                    }
                    this.onServerBusy(busyStartTime);
                    object = this.connectionsMonitor;
                    synchronized (object) {
                        try {
                            this.connectionsMonitor.wait(this.serverBusyTimeout);
                        }
                        catch (InterruptedException e) {
                            throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting on server resources").initCause(e);
                        }
                    }
                }
                busyStartTime = 0L;
                if (this.stopRequested.get() || server == null) break;
                object = this;
                synchronized (object) {
                    this.notifyAll();
                }
                this.ready.set(true);
                this.onServerReady(this.connectionPool.getActiveThreadCount());
                try {
                    Socket theSocket;
                    socket = theSocket = ((ServerSocket)server).accept();
                }
                catch (SocketException e) {
                    if (((ServerSocket)server).isClosed()) break;
                    throw e;
                }
                try {
                    socket.setSoTimeout(this.socketTimeout);
                }
                catch (SocketException e) {
                    this.onSocketExceptionAfterAccept(socket, e);
                    socket.close();
                    continue;
                }
                this.onSubmitted(socket, this.submit(socket, this.connectionPool));
            }
            catch (SocketTimeoutException e) {
                if (!this.connectionPool.isQuiescent()) continue;
                this.onServerShuttingDown();
                this.connectionPool.shutdown();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void stop() throws IOException {
        this.stopRequested.set(true);
        this.ready.set(false);
        SocketServer socketServer = this;
        synchronized (socketServer) {
            V theServerSocket = this.serverSocket;
            this.serverSocket = null;
            try {
                if (theServerSocket == null) {
                    return;
                }
                ScheduledFuture<IOException> future = this.timeoutFuture;
                if (future != null) {
                    future.cancel(false);
                    this.timeoutFuture = null;
                }
                ((ServerSocket)theServerSocket).close();
            }
            finally {
                this.notifyAll();
            }
        }
    }

    private Future<?> submit(S socket, ExecutorService executor) {
        Objects.requireNonNull(socket);
        return executor.submit(new Runnable(){
            final /* synthetic */ Socket val$socket;
            final /* synthetic */ SocketServer this$0;
            {
                this.val$socket = socket;
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.this$0.onBeforeServingSocket(this.val$socket);
                try {
                    this.this$0.doServeSocket(this.val$socket);
                }
                catch (Exception e) {
                    this.this$0.onServingException(this.val$socket, e);
                }
                catch (Throwable t) {
                    this.this$0.onServingException(this.val$socket, t);
                }
                finally {
                    Object e = this.this$0.connectionsMonitor;
                    synchronized (e) {
                        this.this$0.connectionsMonitor.notifyAll();
                    }
                    this.this$0.doSocketClose(this.val$socket);
                    this.this$0.onAfterServingSocket(this.val$socket);
                }
            }
        });
    }

    protected void doSocketClose(S socket) {
        try {
            ((Socket)socket).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<IOException> startThenStopAfter(long delay, TimeUnit unit) {
        if (this.stopRequested.get()) {
            return null;
        }
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.start();
            ScheduledFuture<IOException> existingFuture = this.timeoutFuture;
            if (existingFuture != null) {
                existingFuture.cancel(false);
            }
            this.timeoutFuture = TIMEOUTS.schedule(new Callable<IOException>(){

                @Override
                @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
                public IOException call() throws Exception {
                    try {
                        SocketServer.this.stop();
                        return null;
                    }
                    catch (IOException e) {
                        return e;
                    }
                }
            }, delay, unit);
            return this.timeoutFuture;
        }
    }

    protected abstract void doServeSocket(S var1) throws IOException;

    protected void onServerStarting() {
    }

    protected void onServerBound(A address) {
    }

    protected void onServerReady(int activeCount) {
    }

    protected void onServerBusy(long busyStartTime) {
    }

    protected void onServerStopped(V socket) {
    }

    protected void onSubmitted(S socket, Future<?> submission) {
    }

    protected void onServerShuttingDown() {
    }

    protected void onSocketExceptionDuringAccept(SocketException e) {
    }

    protected void onSocketExceptionAfterAccept(S socket, SocketException e) {
    }

    protected void onBeforeServingSocket(S socket) {
    }

    @Deprecated
    protected void onServingException(S socket, Exception e) {
        this.onServingException(socket, (Throwable)e);
    }

    protected void onServingException(S socket, Throwable t) {
    }

    protected void onAfterServingSocket(S socket) {
    }

    @Deprecated
    protected void onListenException(Exception e) {
        this.onListenException((Throwable)e);
    }

    protected void onListenException(Throwable t) {
    }

    protected @NonNull A getListenAddress() {
        return this.listenAddress;
    }
}

