/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.tipc.AFTIPCAddressSpecifics;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocket;
import org.newsclub.net.unix.tipc.AFTIPCTopologyEvent;
import org.newsclub.net.unix.tipc.AFTIPCTopologyWatcher;
import org.opentest4j.AssertionFailedError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_TIPC})
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_THROWABLE", "THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
public final class AFTIPCTopologyWatcherTest
extends SocketTestBase<AFTIPCSocketAddress> {
    public AFTIPCTopologyWatcherTest() throws IOException {
        super(AFTIPCAddressSpecifics.INSTANCE);
    }

    @Test
    public void testSubscriptionEvents() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        final AtomicInteger numPortEvents = new AtomicInteger(0);
        final AtomicInteger numServiceEvents = new AtomicInteger(0);
        final AtomicBoolean foundTestService = new AtomicBoolean(false);
        final AtomicBoolean foundTestServiceWithdrawal = new AtomicBoolean(false);
        try (AFTIPCDatagramSocket testServiceSock = AFTIPCDatagramSocket.newInstance();){
            testServiceSock.bind((SocketAddress)AFTIPCSocketAddress.ofServiceRange((int)1234, (int)5678, (int)91011));
            final AFTIPCSocketAddress bindAddress = (AFTIPCSocketAddress)testServiceSock.getLocalSocketAddress();
            final CompletableFuture cf = new CompletableFuture();
            try (AFTIPCTopologyWatcher watcher = new AFTIPCTopologyWatcher(){

                protected void onEvent(AFTIPCTopologyEvent event) throws IOException {
                    Assertions.assertTrue((boolean)this.isRunning());
                    Assertions.assertThrows(IllegalStateException.class, () -> this.runLoop());
                    if (event.isPublished()) {
                        if (event.isPort()) {
                            Assertions.assertFalse((boolean)event.isService());
                            Assertions.assertFalse((boolean)event.isCancellationRequest());
                            numPortEvents.incrementAndGet();
                        } else if (event.isService()) {
                            Assertions.assertFalse((boolean)event.isPort());
                            Assertions.assertFalse((boolean)event.isCancellationRequest());
                            numServiceEvents.incrementAndGet();
                            if (event.getAddress().equals((Object)bindAddress)) {
                                foundTestService.set(true);
                                this.stopLoop();
                            }
                        }
                    } else if (event.isWithdrawn()) {
                        Assertions.assertFalse((boolean)event.isCancellationRequest());
                        if (event.isService() && event.getAddress().equals((Object)bindAddress) && event.getFoundLower() == 5678 && event.getFoundUpper() == 91011) {
                            foundTestServiceWithdrawal.set(true);
                            this.stopLoop();
                            cf.complete(null);
                        }
                    }
                }
            };){
                watcher.addPortSubscription();
                watcher.addServiceSubscription(1234);
                Thread t = new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        watcher.close();
                        cf.complete(null);
                    }
                    catch (Exception e) {
                        cf.completeExceptionally(e);
                    }
                });
                t.setDaemon(true);
                t.start();
                watcher.runLoop();
                Assertions.assertFalse((boolean)watcher.isRunning());
                if (numPortEvents.get() == 0) {
                    throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_INFORMATIONAL, "TIPC enabled but no bearer set up? If you don't need TIPC, consider \"rmmod tipc\".");
                }
                Assertions.assertNotEquals((int)0, (int)numPortEvents.get(), (String)"We should have seen at least one port event");
                Assertions.assertNotEquals((int)0, (int)numServiceEvents.get(), (String)"We should have seen at least service event");
                Assertions.assertTrue((boolean)foundTestService.get(), (String)"We should have found our test service");
                Assertions.assertFalse((boolean)foundTestServiceWithdrawal.get());
                testServiceSock.close();
                watcher.runLoop();
                Assertions.assertTrue((boolean)foundTestServiceWithdrawal.get());
            }
            cf.get(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testGetNodeId() throws Exception {
        AFTIPCSocketAddress addr = (AFTIPCSocketAddress)AFTIPCDatagramSocket.newInstance().getLocalSocketAddress();
        Assertions.assertNotNull((Object)addr);
        Objects.requireNonNull(addr);
        String str = AFTIPCSocket.getNodeIdHexString((int)addr.getTIPCNodeHash());
        if (str != null) {
            Assertions.assertNotEquals((int)0, (int)str.length());
        }
    }

    @Test
    public void testClusterConnectivity() throws Exception {
        try (AFTIPCTopologyWatcher watcher = new AFTIPCTopologyWatcher(0){

            protected void onEvent(AFTIPCTopologyEvent event) throws IOException {
                String linkName;
                if (event.isTimeout()) {
                    this.stopLoop();
                    return;
                }
                if (event.isPublished() && (linkName = event.getLinkName()) != null) {
                    Assertions.assertNotEquals((int)0, (int)linkName.length());
                    Assertions.assertTrue((linkName.indexOf(58) >= 0 ? 1 : 0) != 0, (String)linkName);
                }
            }
        };){
            watcher.addLinkStateSubscription();
            try {
                Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> watcher.runLoop());
            }
            catch (AssertionFailedError e) {
                throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, "Kernel may be too old for full TIPC support", (Throwable)e);
            }
        }
    }
}

