/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.testutil.TestAbortedWithImportantMessageException;
import com.kohlschutter.testutil.TestAsyncUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.InvalidArgumentSocketException;
import org.newsclub.net.unix.SocketClosedException;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SocketChannelTest<A extends SocketAddress>
extends SocketTestBase<A> {
    protected SocketChannelTest(AddressSpecifics<A> asp) {
        super(asp);
    }

    @Test
    public void testNonBlockingConnect() throws IOException {
        SocketAddress sa = this.newTempAddress();
        ServerSocketChannel ssc = this.selectorProvider().openServerSocketChannel();
        ssc.configureBlocking(false);
        this.bindServerSocket(ssc, sa, 1);
        sa = ssc.getLocalAddress();
        SocketChannel sc = this.selectorProvider().openSocketChannel();
        sc.configureBlocking(false);
        if (!this.handleConnect(sc, sa)) {
            Assertions.assertTrue((sc.isConnected() || sc.isConnectionPending() ? 1 : 0) != 0);
            long now = System.currentTimeMillis();
            while (!sc.finishConnect()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (System.currentTimeMillis() - now > 1000L) {
                    Assertions.fail((String)"Non-blocking connect not connected after 1s");
                    break;
                }
                if (!Thread.interrupted()) continue;
            }
            Assertions.assertTrue((boolean)sc.finishConnect());
        }
        Assertions.assertTrue((boolean)sc.isConnected());
        Assertions.assertFalse((boolean)sc.isConnectionPending());
    }

    @Test
    public void testDoubleBindAddressNotReusable() throws Exception {
        this.testDoubleBind(false);
    }

    @Test
    public void testDoubleBindAddressReusable() throws Exception {
        this.testDoubleBind(true);
    }

    private void testDoubleBind(boolean reuseAddress) throws Exception {
        String triggerWithIssues;
        Future connectCall;
        block31: {
            Future acceptCall2;
            Future acceptCall;
            SocketAddress sa0 = this.newTempAddress();
            connectCall = null;
            AtomicBoolean socketDomainWillAcceptCallOnFirstBind = new AtomicBoolean(true);
            try (ServerSocketChannel ssc1 = this.selectorProvider().openServerSocketChannel();){
                this.bindServerSocket(ssc1, sa0, 1);
                SocketAddress sa = this.resolveAddressForSecondBind(sa0, ssc1);
                AtomicBoolean connectMustSucceed = new AtomicBoolean(false);
                AtomicBoolean wasRebound = new AtomicBoolean(false);
                acceptCall = TestAsyncUtil.supplyAsync(() -> {
                    try {
                        SocketChannel sc;
                        try {
                            sc = ssc1.accept();
                        }
                        catch (SocketClosedException e) {
                            if (wasRebound.get()) {
                                return null;
                            }
                            throw e;
                        }
                        socketDomainWillAcceptCallOnFirstBind.set(false);
                        Objects.requireNonNull(sc);
                        if (!reuseAddress || !connectMustSucceed.get()) {
                            // empty if block
                        }
                        return sc;
                    }
                    catch (SocketException e) {
                        String msg = this.checkKnownBugAcceptFailure(e);
                        if (msg != null) {
                            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, msg, this.summaryImportantMessage(msg), (Throwable)e);
                        }
                        if (!reuseAddress) {
                            Assertions.fail((Throwable)e);
                        }
                    }
                    catch (SocketTimeoutException e) {
                        String msg = this.checkKnownBugAcceptFailure(e);
                        if (msg != null) {
                            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, msg, this.summaryImportantMessage(msg), (Throwable)e);
                        }
                        Assertions.fail((Throwable)e);
                    }
                    catch (IOException e) {
                        Assertions.fail((Throwable)e);
                    }
                    return null;
                });
                try (ServerSocketChannel ssc2 = this.selectorProvider().openServerSocketChannel();){
                    block29: {
                        ssc2.socket().setReuseAddress(reuseAddress);
                        try {
                            wasRebound.set(true);
                            this.bindServerSocket(ssc2, sa, 1);
                            if (!reuseAddress && !this.socketDomainPermitsDoubleBind()) {
                                Assertions.fail((String)"Did not throw expected SocketException (Address already in use)");
                            }
                        }
                        catch (SocketException e) {
                            if (!reuseAddress) break block29;
                            connectMustSucceed.set(true);
                        }
                    }
                    acceptCall2 = reuseAddress ? TestAsyncUtil.supplyAsync(() -> {
                        try {
                            SocketChannel sc = ssc2.accept();
                            socketDomainWillAcceptCallOnFirstBind.set(false);
                            Objects.requireNonNull(sc);
                            return sc;
                        }
                        catch (InvalidArgumentSocketException e) {
                            if (!acceptCall.isDone()) {
                                socketDomainWillAcceptCallOnFirstBind.set(true);
                            } else {
                                Assertions.fail((Throwable)e);
                            }
                        }
                        catch (IOException e) {
                            Assertions.fail((Throwable)e);
                        }
                        return null;
                    }) : null;
                    if (!acceptCall.isDone() && socketDomainWillAcceptCallOnFirstBind.get()) {
                        connectCall = TestAsyncUtil.supplyAsync(() -> {
                            try {
                                this.newSocket().connect(sa);
                            }
                            catch (SocketException e) {
                                if (connectMustSucceed.get()) {
                                    Assertions.fail((String)"Connect should have succeeded", (Throwable)e);
                                }
                            }
                            catch (IOException e) {
                                Assertions.fail((Throwable)e);
                            }
                        });
                    }
                }
            }
            if (acceptCall2 != null) {
                try {
                    acceptCall2.get(5L, TimeUnit.SECONDS);
                }
                catch (ExecutionException ssc1) {
                }
                catch (TimeoutException e) {
                    Assertions.fail((String)"Second accept call did not terminate");
                }
            }
            triggerWithIssues = null;
            try {
                acceptCall.get(5L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TestAbortedWithImportantMessageException) {
                    throw (TestAbortedWithImportantMessageException)e.getCause();
                }
                throw e;
            }
            catch (TimeoutException e) {
                triggerWithIssues = this.checkKnownBugFirstAcceptCallNotTerminated();
                if (triggerWithIssues != null) break block31;
                Assertions.fail((String)"First accept call did not terminate");
            }
        }
        if (triggerWithIssues != null) {
            throw new TestAbortedWithImportantMessageException(TestAbortedWithImportantMessageException.MessageType.TEST_ABORTED_SHORT_WITH_ISSUES, triggerWithIssues, this.summaryImportantMessage(triggerWithIssues));
        }
        if (connectCall != null) {
            try {
                connectCall.get(5L, TimeUnit.SECONDS);
            }
            catch (ExecutionException e) {
            }
            catch (TimeoutException e) {
                Assertions.fail((String)"Connect call did not terminate");
            }
        }
    }

    protected String checkKnownBugAcceptFailure(SocketException e) {
        return null;
    }

    protected String checkKnownBugAcceptFailure(SocketTimeoutException e) {
        return null;
    }

    protected void handleBind(ServerSocketChannel ssc, SocketAddress sa) throws IOException {
        ssc.bind(sa);
    }

    protected boolean handleConnect(SocketChannel sc, SocketAddress sa) throws IOException {
        return sc.connect(sa);
    }

    @Test
    public void testByteBufferWithPositionOffset() throws Exception {
        SocketAddress sa = this.newTempAddress();
        int bb1Offset = 32;
        boolean bb2Offset = true;
        byte[] data = new byte[96];
        this.getRandom().nextBytes(data);
        try (ServerSocketChannel ssc = this.selectorProvider().openServerSocketChannel();){
            int r;
            this.handleBind(ssc, sa);
            ByteBuffer bb1 = ByteBuffer.allocate(data.length + 32);
            bb1.position(32);
            bb1.put(data);
            bb1.flip();
            bb1.position(32);
            Assertions.assertEquals((int)32, (int)bb1.position());
            TestAsyncUtil.runAsync(() -> {
                try (SocketChannel sc = ssc.accept();){
                    int written = 0;
                    while (bb1.hasRemaining()) {
                        written += sc.write(bb1);
                    }
                    Assertions.assertEquals((int)data.length, (int)written);
                }
                catch (IOException e) {
                    Assertions.fail((Throwable)e);
                }
            });
            SocketChannel sc = this.selectorProvider().openSocketChannel();
            ByteBuffer bb2 = ByteBuffer.allocate(data.length + 1);
            Assertions.assertTrue((boolean)this.handleConnect(sc, ssc.getLocalAddress()));
            bb2.position(1);
            int read = 0;
            while ((r = sc.read(bb2)) != -1) {
                read += r;
                if (bb2.hasRemaining()) continue;
            }
            Assertions.assertEquals((int)data.length, (int)read);
            Assertions.assertEquals((int)bb1.capacity(), (int)bb1.position());
            Assertions.assertEquals((int)bb1.capacity(), (int)bb1.limit());
            Assertions.assertEquals((int)(data.length + 1), (int)bb2.position());
            Assertions.assertEquals((int)bb2.capacity(), (int)bb2.limit());
            bb1.position(32);
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                Assertions.assertEquals((byte)bb1.get(32 + i), (byte)bb2.get(1 + i), (String)("at pos " + i));
            }
        }
    }

    protected String checkKnownBugFirstAcceptCallNotTerminated() {
        return null;
    }

    protected SocketAddress resolveAddressForSecondBind(SocketAddress originalAddress, ServerSocketChannel ssc) throws IOException {
        return ssc.getLocalAddress();
    }

    protected boolean socketDomainPermitsDoubleBind() {
        return false;
    }
}

