/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.util.IOUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.server.RMISocketFactory;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.rmi.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.rmi.NaiveFileInputStreamRemote;
import org.newsclub.net.unix.rmi.RemoteFileDescriptor;
import org.newsclub.net.unix.rmi.RemotePeerInfo;
import org.newsclub.net.unix.rmi.TestBase;
import org.newsclub.net.unix.rmi.TestService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN, AFSocketCapability.CAPABILITY_FILE_DESCRIPTORS})
public class RemoteFileDescriptorTest
extends TestBase {
    private static final byte[] HELLO_WORLD = "Hello World :-)\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SMILEY = ":-)\n".getBytes(StandardCharsets.US_ASCII);

    @Test
    public void testServiceProxy() throws IOException, NotBoundException {
        TestService svc = this.lookupTestService();
        Assertions.assertTrue((boolean)Proxy.isProxyClass(svc.getClass()));
    }

    @Test
    public void testRemoteStdout() throws IOException, NotBoundException {
        TestService svc = this.lookupTestService();
        try (RemoteFileDescriptor stdout = svc.stdout();
             FileOutputStream fos = new FileOutputStream(stdout.getFileDescriptor());){
            fos.flush();
        }
    }

    @Test
    public void testRemoteStdoutNoop() throws IOException, NotBoundException {
        TestService svc = this.lookupTestService();
        RemoteFileDescriptor unused = svc.stdout();
        if (unused != null) {
            unused.close();
        }
    }

    @Test
    public void testWriteAndReadHello() throws IOException, NotBoundException {
        TestService svc = this.lookupTestService();
        try (FileOutputStream fos = svc.output().asFileOutputStream();){
            fos.write(HELLO_WORLD);
        }
        svc.verifyContents(HELLO_WORLD);
        try (FileInputStream fin = svc.input(12L).asFileInputStream();){
            byte[] data = IOUtil.readAllBytes((InputStream)fin);
            Assertions.assertArrayEquals((byte[])SMILEY, (byte[])data);
        }
        try (NaiveFileInputStreamRemote rfis = svc.naiveInputStreamRemote();
             FileInputStream fin = Objects.requireNonNull(rfis.getRemoteFileDescriptor().asFileInputStream());){
            Assertions.assertEquals((int)72, (int)rfis.read());
            Assertions.assertEquals((int)101, (int)fin.read());
            Assertions.assertEquals((int)108, (int)fin.read());
            Assertions.assertEquals((int)108, (int)fin.read());
            fin.close();
            Assertions.assertEquals((int)111, (int)rfis.read());
        }
    }

    @Test
    public void testFindSocketFactory() throws IOException, NotBoundException {
        TestService svc = this.lookupTestService();
        RemotePeerInfo rci = RemotePeerInfo.getConnectionInfo((Remote)svc);
        RMISocketFactory factory = rci.getSocketFactory();
        Assertions.assertNotNull((Object)factory);
        Assertions.assertEquals((Object)this.namingSocketFactory(), (Object)factory);
    }

    @Test
    public void testReadWrite() throws IOException, NotBoundException {
        byte[] actual;
        TestService svc = this.lookupTestService();
        byte[] expected = new byte[5000];
        for (int i = 0; i < expected.length; ++i) {
            expected[i] = (byte)((i + 123) % 256);
        }
        try (FileOutputStream fos = svc.output().asFileOutputStream();){
            fos.write(expected);
        }
        try (Closeable fin = svc.input().asFileInputStream();){
            actual = IOUtil.readAllBytes((InputStream)fin);
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        fin = svc.naiveInputStreamRemote();
        try {
            actual = fin.readAllBytes();
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }
}

