/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.SocketTestBase;
import org.newsclub.net.unix.tipc.AFTIPCTopologyWatcherTest;
import org.newsclub.net.unix.tipc.AcceptTimeoutTest;
import org.newsclub.net.unix.tipc.AncillaryMessageTest;
import org.newsclub.net.unix.tipc.AvailableTest;
import org.newsclub.net.unix.tipc.BufferOverflowTest;
import org.newsclub.net.unix.tipc.CancelAcceptTest;
import org.newsclub.net.unix.tipc.DatagramSocketTest;
import org.newsclub.net.unix.tipc.EndOfFileTest;
import org.newsclub.net.unix.tipc.ReadWriteTest;
import org.newsclub.net.unix.tipc.SelectorTest;
import org.newsclub.net.unix.tipc.ServerSocketCloseTest;
import org.newsclub.net.unix.tipc.ServerSocketTest;
import org.newsclub.net.unix.tipc.SoTimeoutTest;
import org.newsclub.net.unix.tipc.SocketChannelTest;
import org.newsclub.net.unix.tipc.SocketOptionsTest;
import org.newsclub.net.unix.tipc.SocketPairTest;
import org.newsclub.net.unix.tipc.SocketTest;
import org.newsclub.net.unix.tipc.StandardSocketOptionsTest;
import org.newsclub.net.unix.tipc.TcpNoDelayTest;
import org.newsclub.net.unix.tipc.ThroughputTest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SelftestProvider {
    final Map<String, LinkedHashSet<Class<?>>> testMap = new LinkedHashMap();

    public SelftestProvider() {
        this.registerTest(AcceptTimeoutTest.class);
        this.registerTest(AFTIPCTopologyWatcherTest.class);
        this.registerTest(AncillaryMessageTest.class);
        this.registerTest(AvailableTest.class);
        this.registerTest(BufferOverflowTest.class);
        this.registerTest(CancelAcceptTest.class);
        this.registerTest(DatagramSocketTest.class);
        this.registerTest(EndOfFileTest.class);
        this.registerTest(ReadWriteTest.class);
        this.registerTest(SelectorTest.class);
        this.registerTest(ServerSocketCloseTest.class);
        this.registerTest(ServerSocketTest.class);
        this.registerTest(SocketChannelTest.class);
        this.registerTest(SocketOptionsTest.class);
        this.registerTest(SocketPairTest.class);
        this.registerTest(SocketTest.class);
        this.registerTest(SoTimeoutTest.class);
        this.registerTest(StandardSocketOptionsTest.class);
        this.registerTest(TcpNoDelayTest.class);
        this.registerTest(ThroughputTest.class);
    }

    public Set<String> modulesDisabledByDefault() {
        return Collections.singleton("junixsocket-common.JavaInet");
    }

    private void registerTest(Class<? extends SocketTestBase<AFTIPCSocketAddress>> testTIPC) {
        this.registerTest("junixsocket-tipc", testTIPC);
    }

    private void registerTest(String group, Class<?> test) {
        if (test != null) {
            this.testMap.computeIfAbsent(group, key -> new LinkedHashSet()).add(test);
        }
    }

    public Map<String, Class<?>[]> tests() {
        LinkedHashMap<String, Class<?>[]> tests = new LinkedHashMap<String, Class<?>[]>();
        this.testMap.forEach((key, set) -> tests.put((String)key, set.toArray(new Class[0])));
        return tests;
    }

    public void printAdditionalProperties(PrintWriter out) {
    }
}

