/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.selftest;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.util.ConsolePrintStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.engine.JupiterTestEngine;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.JuxPackageAccess;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
class SelftestExecutor {
    private final List<Class<?>> testClasses;
    private final String prefix;
    private final Map<String, TestIdentifier> tids = new HashMap<String, TestIdentifier>();
    private final Map<TestIdentifier, TestExecutionResult> testsWithWarnings = new LinkedHashMap<TestIdentifier, TestExecutionResult>();

    SelftestExecutor(List<Class<?>> testClasses, String prefix) {
        this.testClasses = testClasses;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TestExecutionSummary execute(final ConsolePrintStream out0) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)out0, Charset.defaultCharset()));
        try {
            LauncherConfig launcherConfig = LauncherConfig.builder().enableTestEngineAutoRegistration(false).addTestEngines(new TestEngine[]{new JupiterTestEngine()}).build();
            Launcher launcher = LauncherFactory.create((LauncherConfig)launcherConfig);
            SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener, JuxPackageAccess.newTreePrintingListener(out, true, Theme.ASCII)});
            LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
            requestBuilder.configurationParameter("junit.jupiter.execution.timeout.testable.method.default", System.getProperty("selftest.test-timeout", "30 s"));
            requestBuilder.selectors(this.testClasses.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList()));
            LauncherDiscoveryRequest discoveryRequest = requestBuilder.build();
            TestPlan testPlan = launcher.discover(discoveryRequest);
            this.tids.clear();
            launcher.execute(testPlan, new TestExecutionListener[]{new TestExecutionListener(){

                public void executionStarted(TestIdentifier tid) {
                    SelftestExecutor.this.tids.put(tid.getUniqueId(), tid);
                    Optional pid = tid.getParentId();
                    if (tid.getType().isTest() && pid.isPresent()) {
                        out0.update(SelftestExecutor.this.prefix + SelftestExecutor.this.tids.get(pid.get()).getDisplayName() + "." + tid.getDisplayName() + "... ");
                    }
                }

                public void executionFinished(TestIdentifier tid, TestExecutionResult testExecutionResult) {
                    if (!tid.getParentId().isPresent()) {
                        out0.updateln(SelftestExecutor.this.prefix + "done");
                    }
                    if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
                        SelftestExecutor.this.testsWithWarnings.put(tid, testExecutionResult);
                    }
                }
            }});
            TestExecutionSummary summary = summaryListener.getSummary();
            summary.printFailuresTo(out);
            summary.printTo(out);
            TestExecutionSummary testExecutionSummary = summary;
            return testExecutionSummary;
        }
        finally {
            out.flush();
        }
    }

    Map<TestIdentifier, TestExecutionResult> getTestsWithWarnings() {
        return this.testsWithWarnings;
    }

    TestIdentifier getTestIdentifier(String id) {
        return this.tids.get(id);
    }
}

