/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.tipc;

import com.kohlschutter.util.ProcessUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.AddressSpecifics;
import org.newsclub.net.unix.CloseablePair;
import org.newsclub.net.unix.tipc.AFTIPCDatagramSocket;
import org.newsclub.net.unix.tipc.AFTIPCSelectorProvider;
import org.newsclub.net.unix.tipc.AFTIPCServerSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocket;
import org.newsclub.net.unix.tipc.AFTIPCSocketPair;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFTIPCAddressSpecifics
implements AddressSpecifics<AFTIPCSocketAddress> {
    private static final int TIPC_TYPE = (int)(ProcessUtil.getPid() % Integer.MAX_VALUE) + 64;
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    public static final AddressSpecifics<AFTIPCSocketAddress> INSTANCE = new AFTIPCAddressSpecifics();

    private AFTIPCAddressSpecifics() {
    }

    @Override
    public AFSocketAddress initServerSocketBindAddress() throws IOException {
        return AFTIPCSocketAddress.ofService(AFTIPCSocketAddress.Scope.SCOPE_NODE, TIPC_TYPE, INSTANCE_COUNTER.incrementAndGet());
    }

    @Override
    public AFSocket<?> newSocket() throws IOException {
        return AFTIPCSocket.newInstance();
    }

    @Override
    public AFSocket<?> newStrictSocket() throws IOException {
        return AFTIPCSocket.newStrictInstance();
    }

    @Override
    public AFDatagramSocket<?> newDatagramSocket() throws IOException {
        return AFTIPCDatagramSocket.newInstance();
    }

    @Override
    public DatagramChannel newDatagramChannel() throws IOException {
        return AFTIPCDatagramSocket.newInstance().getChannel();
    }

    @Override
    public AFServerSocket<?> newServerSocket() throws IOException {
        return AFTIPCServerSocket.newInstance();
    }

    @Override
    public AFSocketAddress newTempAddress() throws IOException {
        return AFTIPCSocketAddress.ofService(AFTIPCSocketAddress.Scope.SCOPE_NODE, TIPC_TYPE, INSTANCE_COUNTER.incrementAndGet());
    }

    @Override
    public AFSocketAddress unwrap(InetAddress addr, int port) throws SocketException {
        return AFTIPCSocketAddress.unwrap(addr, port);
    }

    @Override
    public AFSelectorProvider<?> selectorProvider() {
        return AFTIPCSelectorProvider.provider();
    }

    @Override
    public CloseablePair<? extends SocketChannel> newSocketPair() throws IOException {
        return AFTIPCSocketPair.open();
    }

    @Override
    public CloseablePair<? extends DatagramChannel> newDatagramSocketPair() throws IOException {
        return AFTIPCSocketPair.openDatagram();
    }

    @Override
    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr) throws IOException {
        return AFTIPCServerSocket.bindOn((AFTIPCSocketAddress)((AFTIPCSocketAddress)addr));
    }

    @Override
    public Socket connectTo(SocketAddress socket) throws IOException {
        return AFTIPCSocket.connectTo((AFTIPCSocketAddress)((AFTIPCSocketAddress)socket));
    }

    @Override
    public AFServerSocket<?> newServerSocketBindOn(SocketAddress addr, boolean deleteOnClose) throws IOException {
        return AFTIPCServerSocket.bindOn((AFTIPCSocketAddress)((AFTIPCSocketAddress)addr), (boolean)deleteOnClose);
    }

    @Override
    public CloseablePair<? extends Socket> newInterconnectedSockets() throws IOException {
        CloseablePair<? extends SocketChannel> sp = this.newSocketPair();
        return new CloseablePair<Socket>(sp.getFirst().socket(), sp.getSecond().socket());
    }
}

