/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.testutil.ForkedVM;
import com.kohlschutter.testutil.ForkedVMRequirement;
import com.kohlschutter.testutil.OutputBridge;
import java.io.File;
import java.io.IOException;
import java.rmi.ServerException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.rmi.AFUNIXNaming;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.Hello;
import org.newsclub.net.unix.rmi.TestRegistryServer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ForkedVMRequirement(forkSupported=true)
public class RemoteRegistryTest {
    @Test
    public void testRemoteRegistry() throws Exception {
        File socketDir = this.tempSocketDir();
        try (SpawnedRegistryAccess sra = new SpawnedRegistryAccess(TestRegistryServer.class.getSimpleName(), socketDir){

            @Override
            protected int exportHelloDelayMillis() {
                return 500;
            }
        };){
            this.tryToSayHello(sra);
            sra.shutdown();
        }
        Assertions.assertEquals((int)0, (int)this.countRMIFiles(socketDir));
        Assertions.assertTrue((boolean)socketDir.delete());
    }

    @Test
    public void testRemoteRegistryStandardPath() throws Exception {
        File socketDir = AFUNIXNaming.getDefaultSocketDirectory();
        Assumptions.assumeTrue((this.countRMIFiles(socketDir) == 0 ? 1 : 0) != 0, (String)("Test cannot be performed: *.rmi files exist in directory: " + socketDir));
        int n = 2;
        for (int i = 1; i <= n; ++i) {
            System.out.println("Attempt " + i + "/" + n);
            try (SpawnedRegistryAccess sra = new SpawnedRegistryAccess(TestRegistryServer.class.getSimpleName()){

                @Override
                protected AFUNIXNaming getNamingInstance() throws IOException {
                    return AFUNIXNaming.getInstance();
                }
            };){
                this.tryToSayHello(sra);
                sra.shutdown();
            }
            Assertions.assertEquals((int)0, (int)this.countRMIFiles(socketDir));
        }
    }

    @Test
    public void testRemoteShutdownNotAllowed() throws Exception {
        File socketDir = this.tempSocketDir();
        try (SpawnedRegistryAccess sra = new SpawnedRegistryAccess(TestRegistryServer.class.getSimpleName(), socketDir){

            @Override
            protected boolean remoteShutdownAllowed() {
                return false;
            }

            @Override
            protected int shutdownAfterSecs() {
                return 30;
            }
        };){
            AFUNIXRegistry registry = sra.getRegistry();
            Assertions.assertNotNull((Object)registry, (String)"Could not access the AFUNIXRegistry created by the forked VM");
            Assertions.assertThrows(ServerException.class, () -> sra.getRegistry().getNaming().shutdownRegistry());
            sra.shutdownAndWait(true);
        }
        Assertions.assertEquals((int)0, (int)this.countRMIFiles(socketDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToSayHello(SpawnedRegistryAccess sra) throws Exception {
        AFUNIXRegistry registry = sra.getRegistry();
        Assertions.assertNotNull((Object)registry, (String)"Could not access the AFUNIXRegistry created by the forked VM");
        AFUNIXNaming naming = registry.getNaming();
        try {
            Hello hello = (Hello)naming.lookup("hello", 20L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"Hello", (Object)hello.hello());
        }
        finally {
            naming.shutdownRegistry();
            int rc = sra.shutdownAndWait();
            Assertions.assertEquals((int)0, (int)rc, (String)(TestRegistryServer.class.getName() + " process terminated with return code " + rc));
        }
    }

    private File tempSocketDir() throws IOException {
        File socketDir = File.createTempFile("jux", "");
        Assumptions.assumeTrue((this.countRMIFiles(socketDir) == 0 ? 1 : 0) != 0, (String)("Test cannot be performed: *.rmi files exist in directory: " + socketDir));
        Assertions.assertTrue((boolean)socketDir.delete());
        Assertions.assertTrue((boolean)socketDir.mkdir());
        return socketDir;
    }

    private int countRMIFiles(File dir) {
        File[] files = dir.listFiles((d, name) -> name.endsWith(".rmi"));
        return files == null ? 0 : files.length;
    }

    private static class SpawnedRegistryAccess
    implements AutoCloseable {
        private final File socketDir;
        private final ExecutorService executors;
        private final Process registryProcess;
        private final CompletableFuture<AFUNIXRegistry> registryFuture;
        private final AtomicBoolean markedShutdown = new AtomicBoolean(false);
        private final String prefix;
        private final OutputBridge bridgeOut;
        private final OutputBridge bridgeErr;

        SpawnedRegistryAccess(String id) throws IOException {
            this(id, AFUNIXNaming.getDefaultSocketDirectory());
        }

        SpawnedRegistryAccess(String id, File socketDir) throws IOException {
            long pid;
            this.socketDir = socketDir;
            this.executors = Executors.newCachedThreadPool();
            this.registryFuture = new CompletableFuture();
            this.registryProcess = this.launchRegistryProcess();
            try {
                pid = this.registryProcess.pid();
            }
            catch (UnsupportedOperationException e) {
                pid = -1L;
            }
            this.prefix = "(" + id + (String)(pid != -1L ? " " + this.registryProcess.pid() : "") + ") ";
            this.bridgeOut = new OutputBridge(this.registryProcess, OutputBridge.ProcessStream.STDOUT, this.prefix);
            this.bridgeErr = new OutputBridge(this.registryProcess, OutputBridge.ProcessStream.STDERR, this.prefix);
            this.watchProcessAsync();
            this.asyncGetRegistry();
        }

        void shutdown() {
            this.markedShutdown.set(true);
            this.executors.shutdownNow();
        }

        int shutdownAndWait() throws InterruptedException {
            return this.shutdownAndWait(false);
        }

        int shutdownAndWait(boolean destroy) throws InterruptedException {
            this.shutdown();
            if (destroy) {
                this.registryProcess.destroy();
            }
            return this.registryProcess.waitFor();
        }

        private boolean isShutdown() {
            return this.markedShutdown.get() || this.executors.isShutdown();
        }

        public AFUNIXRegistry getRegistry() throws InterruptedException, ExecutionException {
            return this.registryFuture.get();
        }

        @Override
        public void close() throws Exception {
            this.shutdown();
            this.registryProcess.destroyForcibly();
        }

        private Process launchRegistryProcess() throws IOException {
            return new ForkedVM(){

                protected void onJavaMainClass(String arg) {
                    super.onJavaOption("-Drmitest.junixsocket.socket-dir=" + socketDir.getPath());
                    super.onJavaOption("-Drmitest.junixsocket.create-registry=true");
                    super.onJavaOption("-Drmitest.junixsocket.export-hello=true");
                    super.onJavaOption("-Drmitest.junixsocket.export-hello.delay=" + this.exportHelloDelayMillis());
                    super.onJavaOption("-Drmitest.junixsocket.remote-shutdown.allowed=" + this.remoteShutdownAllowed());
                    super.onJavaOption("-Drmitest.junixsocket.shutdown-after.secs=" + this.shutdownAfterSecs());
                    super.onJavaMainClass(TestRegistryServer.class.getName());
                }

                protected void onArguments(List<String> args) {
                    super.onArguments(Collections.emptyList());
                }
            }.fork();
        }

        protected int shutdownAfterSecs() {
            return -1;
        }

        private void watchProcessAsync() {
            this.executors.submit(() -> {
                try {
                    this.registryProcess.waitFor();
                }
                catch (InterruptedException e) {
                    if (!this.markedShutdown.get()) {
                        this.registryFuture.completeExceptionally(e);
                    }
                    return;
                }
                if (!this.markedShutdown.get() && !this.registryProcess.isAlive()) {
                    this.registryFuture.completeExceptionally(new Exception("The spawned VM has terminated with RC=" + this.registryProcess.exitValue()));
                }
            });
            this.executors.submit((Runnable)this.bridgeOut);
            this.executors.submit((Runnable)this.bridgeErr);
        }

        private void asyncGetRegistry() {
            this.executors.submit(() -> {
                block2: {
                    try {
                        AFUNIXNaming naming = this.getNamingInstance();
                        AFUNIXRegistry registry = naming.getRegistry(30L, TimeUnit.SECONDS);
                        this.registryFuture.complete(registry);
                    }
                    catch (IOException | RuntimeException e) {
                        if (this.isShutdown()) break block2;
                        this.registryFuture.completeExceptionally(e);
                    }
                }
            });
        }

        protected AFUNIXNaming getNamingInstance() throws IOException {
            return AFUNIXNaming.getInstance((File)this.socketDir);
        }

        protected int exportHelloDelayMillis() {
            return 0;
        }

        protected boolean remoteShutdownAllowed() {
            return true;
        }
    }
}

