/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXInetAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AFUNIXInetAddressTest {
    @Test
    public void testFromToBytes() throws IOException {
        byte[] bytes = new byte[]{0, 1, 2, 3, 127, -1};
        Assertions.assertArrayEquals((byte[])bytes, (byte[])AFUNIXInetAddress.unwrapAddress((InetAddress)AFUNIXInetAddress.wrapAddress((byte[])bytes)));
    }

    @Test
    public void testHostnameStringEndsWithJunixSocket() throws IOException {
        byte[] bytes = new byte[]{0, 1, 2, 3, 127, -1};
        Assertions.assertTrue((boolean)AFUNIXInetAddress.wrapAddress((byte[])bytes).getHostName().endsWith(".junixsocket"));
    }

    @Test
    public void testHostnameString() throws IOException {
        Assertions.assertEquals((Object)"[/tmp/test.sock.un.junixsocket", (Object)AFUNIXInetAddress.wrapAddress((byte[])"/tmp/test.sock".getBytes(Charset.defaultCharset())).getHostName());
    }

    @Test
    public void testIsLoopbackAddress() throws IOException {
        Assertions.assertTrue((boolean)AFUNIXInetAddress.wrapAddress((byte[])"/tmp/test.sock".getBytes(Charset.defaultCharset())).isLoopbackAddress());
    }
}

