/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SocketTestBase {
    private static final File SOCKET_FILE = SocketTestBase.initSocketFile();
    private final AFUNIXSocketAddress serverAddress;
    private Exception caller = new Exception();

    public SocketTestBase() throws IOException {
        this.serverAddress = new AFUNIXSocketAddress(SOCKET_FILE);
    }

    @BeforeEach
    public void ensureSocketFileIsDeleted() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        Files.deleteIfExists(SOCKET_FILE.toPath());
    }

    protected AFUNIXSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    static File initSocketFile() {
        File f;
        String explicitFile = System.getProperty("org.newsclub.net.unix.testsocket");
        if (explicitFile != null) {
            f = new File(explicitFile);
        } else {
            try {
                f = File.createTempFile("jutest", ".sock");
                f.deleteOnExit();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't create temporary file", e);
            }
        }
        if (!f.delete()) {
            throw new IllegalStateException("Could not delete temporary file that we just created: " + f);
        }
        return f;
    }

    protected File getSocketFile() {
        return SOCKET_FILE;
    }

    protected AFUNIXServerSocket startServer() throws IOException {
        this.caller = new Exception();
        AFUNIXServerSocket server = AFUNIXServerSocket.newInstance();
        server.bind((SocketAddress)this.serverAddress);
        return server;
    }

    protected AFUNIXSocket connectToServer() throws IOException {
        return AFUNIXSocket.connectTo((AFUNIXSocketAddress)this.serverAddress);
    }

    protected AFUNIXSocket connectToServer(AFUNIXSocket socket) throws IOException {
        socket.connect((SocketAddress)this.serverAddress);
        return socket;
    }

    protected void sleepFor(int ms) throws InterruptedIOException {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (InterruptedIOException)new InterruptedIOException("sleep interrupted").initCause(e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected abstract class ServerThread
    extends Thread {
        private final AFUNIXServerSocket serverSocket;
        private volatile Exception exception = null;
        private final AtomicBoolean loop = new AtomicBoolean(true);
        private final Semaphore sema = new Semaphore(0);

        @SuppressFBWarnings(value={"SC_START_IN_CTOR"})
        protected ServerThread() throws IOException {
            this.serverSocket = this.startServer();
            this.setDaemon(true);
            this.start();
        }

        protected AFUNIXServerSocket startServer() throws IOException {
            return SocketTestBase.this.startServer();
        }

        public void shutdown() throws IOException {
            this.stopAcceptingConnections();
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }

        protected abstract void handleConnection(Socket var1) throws IOException;

        protected void stopAcceptingConnections() {
            this.loop.set(false);
        }

        protected void onServerSocketClose() {
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        protected void handleException(Exception e) {
            e.printStackTrace();
        }

        protected void acceptAndHandleConnection() throws IOException {
            try (AFUNIXSocket sock = this.serverSocket.accept();){
                this.handleConnection((Socket)sock);
            }
        }

        @Override
        public final void run() {
            block7: {
                try {
                    this.loop.set(true);
                    try {
                        while (this.loop.get()) {
                            this.acceptAndHandleConnection();
                        }
                    }
                    finally {
                        this.onServerSocketClose();
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                    }
                }
                catch (IOException e) {
                    if (!this.loop.get() && (this.serverSocket == null || this.serverSocket.isClosed())) break block7;
                    e.addSuppressed(SocketTestBase.this.caller);
                    this.handleException(e);
                    this.exception = e;
                }
            }
            this.sema.release();
        }

        public void checkException() throws Exception {
            this.sema.acquire();
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

