/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFUNIXServerSocket;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.SocketTestBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ServerSocketCloseTest {
    @Test
    public void testUnblockAcceptsWithSoTimeout() throws Exception {
        this.testUnblockAccepts(60000);
    }

    @Test
    public void testUnblockAcceptsWithoutSoTimeout() throws Exception {
        this.testUnblockAccepts(0);
    }

    private void testUnblockAccepts(int timeout) throws Exception {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(5L), () -> {
            File socketFile = SocketTestBase.initSocketFile();
            try (final AFUNIXServerSocket serverSocket = AFUNIXServerSocket.bindOn((AFUNIXSocketAddress)new AFUNIXSocketAddress(socketFile));){
                serverSocket.setSoTimeout(timeout);
                int numThreads = 32;
                final CountDownLatch cdl = new CountDownLatch(32);
                ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                for (int i = 0; i < 32; ++i) {
                    threadPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                cdl.countDown();
                                try (AFUNIXSocket accept = serverSocket.accept();){
                                    Assertions.assertNotNull((Object)accept);
                                }
                            }
                            catch (SocketException e) {
                                if (!serverSocket.isClosed()) {
                                    Assertions.fail((Throwable)e);
                                }
                            }
                            catch (IOException e) {
                                Assertions.fail((Throwable)e);
                            }
                        }
                    });
                }
                cdl.await();
                serverSocket.close();
                threadPool.shutdown();
                threadPool.awaitTermination(500L, TimeUnit.MILLISECONDS);
                Assertions.assertEquals((int)0, (int)threadPool.getActiveCount(), (String)"There should be no pending accepts");
            }
        });
    }
}

