/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.newsclub.net.unix.EndOfFileTest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EndOfFileJavaTest
extends EndOfFileTest {
    int port;

    @Override
    @BeforeEach
    public void setUp() throws IOException {
        String explicitPort = System.getProperty("org.newsclub.net.unix.testport");
        int desiredPort = explicitPort != null ? Integer.parseInt(explicitPort) : 0;
        this.server = new ServerSocket();
        this.server.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), desiredPort), 1);
        this.port = this.server.getLocalPort();
        this.executor = Executors.newFixedThreadPool(2);
    }

    @Override
    @AfterEach
    public void tearDown() throws IOException {
        super.tearDown();
    }

    @Override
    Socket[] connectToServer() throws Exception {
        Socket clientSocket = new Socket();
        Future<Socket> serverAcceptFuture = this.executor.submit(new Callable<Socket>(){

            @Override
            public Socket call() throws Exception {
                return EndOfFileJavaTest.this.server.accept();
            }
        });
        clientSocket.connect(new InetSocketAddress(InetAddress.getLoopbackAddress(), this.port));
        Socket serverSocket = serverAcceptFuture.get(100L, TimeUnit.MILLISECONDS);
        return new Socket[]{serverSocket, clientSocket};
    }
}

