/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.jep380;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.AvailabilityRequirement;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketCapabilityRequirement;
import org.newsclub.net.unix.jep380.JEP380AddressSpecifics;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@AFSocketCapabilityRequirement(value={AFSocketCapability.CAPABILITY_UNIX_DOMAIN})
@AvailabilityRequirement(classes={"java.net.UnixDomainSocketAddress"}, message="This test requires Java 16 or later")
@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
public final class SocketChannelTest
extends org.newsclub.net.unix.SocketChannelTest<SocketAddress> {
    public SocketChannelTest() {
        super(JEP380AddressSpecifics.INSTANCE);
    }

    @Override
    protected boolean mayTestBindNullThrowUnsupportedOperationException() {
        return false;
    }

    @Override
    protected boolean mayTestBindNullHaveNullLocalSocketAddress() {
        return false;
    }

    @Override
    protected void cleanupTestBindNull(ServerSocketChannel sc, SocketAddress addr) throws ClassNotFoundException, IOException {
        if (!Class.forName("java.net.UnixDomainSocketAddress").isAssignableFrom(addr.getClass())) {
            return;
        }
        Path p = Paths.get(addr.toString(), new String[0]);
        Files.delete(p);
    }
}

