/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import com.kohlschutter.testutil.AssertUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFSocketProtocol;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.pool.ObjectPool;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class AFUNIXSocketAddressTest {
    @Test
    public void testSchemesAvailable() throws Exception {
        AssertUtil.assertSetContains((Set)AFAddressFamily.uriSchemes(), Arrays.asList("unix", "http+unix", "https+unix"));
    }

    @Test
    public void testFileScheme() throws Exception {
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/yo")), (Object)AFUNIXSocketAddress.of((URI)URI.create("file:/tmp/yo")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/yo")), (Object)AFUNIXSocketAddress.of((URI)URI.create("file:///tmp/yo")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/yo")), (Object)AFUNIXSocketAddress.of((URI)URI.create("file://localhost/tmp/yo")));
    }

    @Test
    public void testUnixScheme() throws Exception {
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/yo")), (Object)AFUNIXSocketAddress.of((URI)URI.create("unix:/tmp/yo")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/yo")), (Object)AFUNIXSocketAddress.of((URI)URI.create("unix:///tmp/yo")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/tmp/yo")), (Object)AFUNIXSocketAddress.of((URI)URI.create("unix://localhost/tmp/yo")));
    }

    @Test
    public void testHttpUnix() throws Exception {
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/var/run/docker.sock")), (Object)AFUNIXSocketAddress.of((URI)URI.create("http+unix://%2Fvar%2Frun%2Fdocker.sock/info")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/var/run/docker.sock"), (int)8123), (Object)AFUNIXSocketAddress.of((URI)URI.create("http+unix://%2Fvar%2Frun%2Fdocker.sock:8123/info")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("/var/run/docker.sock"), (int)8123), (Object)AFUNIXSocketAddress.of((URI)URI.create("http+unix://foo:bar%40@%2Fvar%2Frun%2Fdocker.sock:8123/info?q1=a1&q2=a2#frag%40")));
        Assertions.assertEquals((Object)AFUNIXSocketAddress.of((File)new File("test"), (int)80), (Object)AFUNIXSocketAddress.of((URI)URI.create("http+unix://test:80/info")));
    }

    private String fixWindowsEncodedPaths(String path) {
        return path.replace("%5C", "%2F");
    }

    private void assertsEqualUnixURIs(URI u1, URI u2) {
        Assertions.assertEquals((Object)this.fixWindowsEncodedPaths(u1.toString()), (Object)this.fixWindowsEncodedPaths(u2.toString()));
    }

    private void assertParseURI(URI u) throws Exception {
        AFUNIXSocketAddress addr = (AFUNIXSocketAddress)AFSocketAddress.of((URI)u);
        URI u2 = addr.toURI(u.getScheme(), u);
        this.assertsEqualUnixURIs(u, u2);
    }

    @Test
    public void testParseURIandBack() throws Exception {
        this.assertParseURI(URI.create("http+unix://foo:bar%40@%2Fvar%2Frun%2Fdocker.sock:8123/info?q1=a1&q2=a2+%40#frag%40"));
        this.assertParseURI(URI.create("http+unix://%2Fvar%2Frun%2Fdocker.sock:8123/info?q1=a1&q2=a2+%40#frag%40"));
        this.assertParseURI(URI.create("http+unix://%2Fvar%2Frun%2Fdocker.sock/info?q1=a1&q2=a2+%40#frag%40"));
        this.assertParseURI(URI.create("http+unix://%2Fvar%2Frun%2Fdocker.sock/info?q1="));
        this.assertParseURI(URI.create("http+unix://%2Fvar%2Frun%2Fdocker.sock:1234"));
    }

    @Test
    public void testURITemplate() throws Exception {
        URI socketURI = URI.create("unix://%2Fvar%2Frun%2Fdocker.sock");
        URI httpURI = URI.create("http://localhost/some/path?q=");
        AFSocketAddress a = AFSocketAddress.of((URI)socketURI);
        Assertions.assertEquals((Object)"https+unix://%2Fvar%2Frun%2Fdocker.sock/some/path?q=", (Object)this.fixWindowsEncodedPaths(a.toURI("https+unix", httpURI).toString()));
    }

    @Test
    public void testURITemplateWithPortNumber() throws Exception {
        URI socketURI = URI.create("unix://%2Fvar%2Frun%2Fdocker.sock");
        URI httpURI = URI.create("http://localhost:8123/some/path?q=");
        AFSocketAddress a = AFSocketAddress.of((URI)socketURI);
        Assertions.assertEquals((Object)"https+unix://%2Fvar%2Frun%2Fdocker.sock/some/path?q=", (Object)this.fixWindowsEncodedPaths(a.toURI("https+unix", httpURI).toString()));
    }

    @Test
    public void testSocatString() throws Exception {
        String socatString = AFUNIXSocketAddress.of((File)new File("/tmp/yo")).toSocatAddressString(null, AFSocketProtocol.DEFAULT);
        if (socatString == null) {
            Assertions.assertFalse((boolean)AFSocket.supports((AFSocketCapability)AFSocketCapability.CAPABILITY_UNIX_DOMAIN));
        } else {
            Assertions.assertTrue((boolean)socatString.contains(":"));
        }
    }

    @Test
    public void testAbstractNamespace() throws Exception {
        Assertions.assertNotNull((Object)AFUNIXSocketAddress.inAbstractNamespace((String)"test"));
        Assertions.assertNotNull((Object)AFUNIXSocketAddress.inAbstractNamespace((String)"test", (int)1234));
    }

    @Test
    public void testSerialize() throws Exception {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            AFUNIXSocketAddress addr = AFUNIXSocketAddress.of((URI)URI.create("file:/tmp/yo"));
            oos.writeObject(addr);
            oos.flush();
            try (ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));){
                AFUNIXSocketAddress addr2 = (AFUNIXSocketAddress)oin.readObject();
                Assertions.assertEquals((Object)addr, (Object)addr2);
                Assertions.assertEquals((Object)addr.getAddressFamily(), (Object)addr2.getAddressFamily());
            }
        }
    }

    @Test
    public void testCraftDeserialization() throws Exception {
        AFUNIXSocketAddress sa1 = AFUNIXSocketAddress.ofNewTempFile();
        byte[] socketAddress = sa1.getBytes();
        try (ObjectPool.Lease nativeAddressLease = sa1.getNativeAddressDirectBuffer();){
            int port = sa1.getPort();
            AFUNIXSocketAddress sa2 = AFUNIXSocketAddress.newAFSocketAddress((int)port, (byte[])socketAddress, (ObjectPool.Lease)nativeAddressLease);
            Assertions.assertEquals((Object)sa1, (Object)sa2);
            Assertions.assertNotEquals((Object)AFUNIXSocketAddress.ofNewTempFile(), (Object)sa2);
        }
    }
}

