/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.rmi.NotBoundException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.rmi.AFNaming;
import org.newsclub.net.unix.rmi.AFRMIService;
import org.newsclub.net.unix.rmi.ShutdownException;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AFRMISocketFactory
extends RMISocketFactory
implements Externalizable,
Closeable {
    private static final long serialVersionUID = 1L;
    private RMIClientSocketFactory defaultClientFactory;
    private RMIServerSocketFactory defaultServerFactory;
    private AFNaming naming;
    private AFRMIService rmiService = null;
    private final Map<Integer, AFServerSocket<?>> openServerSockets = new HashMap();
    private final Set<AFSocket<?>> openSockets = new HashSet();

    public AFRMISocketFactory() {
        this.closeUponRuntimeShutdown();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AFRMISocketFactory(AFNaming naming, RMIClientSocketFactory defaultClientFactory, RMIServerSocketFactory defaultServerFactory) throws IOException {
        this.naming = naming;
        this.defaultClientFactory = defaultClientFactory;
        this.defaultServerFactory = defaultServerFactory;
        this.closeUponRuntimeShutdown();
    }

    private void closeUponRuntimeShutdown() {
        ShutdownHookSupport.addWeakShutdownHook(new ShutdownHookSupport.ShutdownHook(){

            @Override
            public void onRuntimeShutdown(Thread thread) {
                try {
                    AFRMISocketFactory.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected abstract AFSocketAddress newSocketAddress(int var1) throws IOException;

    protected abstract AFSocket<?> newConnectedSocket(AFSocketAddress var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket(String host, int port) throws IOException {
        RMIClientSocketFactory cf = this.defaultClientFactory;
        if (cf != null && port < 100000) {
            return cf.createSocket(host, port);
        }
        AFSocketAddress addr = this.newSocketAddress(port);
        AFSocket<?> socket = this.newConnectedSocket(addr);
        Set<AFSocket<?>> set = this.openSockets;
        synchronized (set) {
            this.openSockets.add(socket);
        }
        socket.addCloseable(() -> {
            Set<AFSocket<?>> set = this.openSockets;
            synchronized (set) {
                this.openSockets.remove(socket);
            }
        });
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AFNaming aFNaming = this.naming;
        synchronized (aFNaming) {
            this.rmiService = null;
            this.closeServerSockets();
            this.closeSockets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AFRMIService getRmiService() throws IOException {
        AFNaming aFNaming = this.naming;
        synchronized (aFNaming) {
            if (this.rmiService == null) {
                try {
                    this.rmiService = this.naming.getRMIService();
                }
                catch (NotBoundException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
            return this.rmiService;
        }
    }

    protected int newPort() throws IOException {
        return this.getRmiService().newPort();
    }

    protected void returnPort(int port) throws IOException {
        this.getRmiService().returnPort(port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (port == 0) {
            int returnPort = port = this.newPort();
            AFSocketAddress addr = this.newSocketAddress(port);
            AFServerSocket ass = addr.getAddressFamily().newServerSocket();
            ass.addCloseable(() -> this.returnPort(returnPort));
            ass.setReuseAddress(true);
            ass.setDeleteOnClose(true);
            ass.bind((SocketAddress)addr);
            if (port >= 100000) {
                ass.addCloseable((Closeable)new ServerSocketCloseable(ass, port));
            }
            return ass;
        }
        RMIServerSocketFactory sf = this.defaultServerFactory;
        if (sf != null && port < 100000) {
            return sf.createServerSocket(port);
        }
        AFSocketAddress addr = this.newSocketAddress(port);
        AFServerSocket socket = addr.getAddressFamily().newServerSocket();
        socket.setDeleteOnClose(true);
        socket.setReuseAddress(true);
        socket.bind((SocketAddress)addr);
        socket.addCloseable((Closeable)new ServerSocketCloseable(socket, port));
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServerSockets() throws IOException {
        HashMap map;
        Map<Integer, AFServerSocket<?>> map2 = this.openServerSockets;
        synchronized (map2) {
            map = new HashMap(this.openServerSockets);
        }
        IOException ex = null;
        for (Map.Entry en : map.entrySet()) {
            try {
                ((AFServerSocket)en.getValue()).close();
            }
            catch (ShutdownException shutdownException) {
            }
            catch (IOException e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        Map<Integer, AFServerSocket<?>> map3 = this.openServerSockets;
        synchronized (map3) {
            this.openServerSockets.clear();
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSockets() {
        HashSet set;
        Set<AFSocket<?>> set2 = this.openSockets;
        synchronized (set2) {
            set = new HashSet(this.openSockets);
        }
        for (AFSocket aFSocket : set) {
            try {
                aFSocket.close();
            }
            catch (IOException iOException) {}
        }
        set2 = this.openSockets;
        synchronized (set2) {
            this.openSockets.clear();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.naming = this.readNamingInstance(in);
        this.defaultClientFactory = (RMIClientSocketFactory)in.readObject();
        this.defaultServerFactory = (RMIServerSocketFactory)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeNamingInstance(out, this.naming);
        out.writeObject(this.defaultClientFactory);
        out.writeObject(this.defaultServerFactory);
    }

    protected abstract AFNaming readNamingInstance(ObjectInput var1) throws IOException;

    protected abstract void writeNamingInstance(ObjectOutput var1, AFNaming var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalServer(int port) {
        if (port < 100000) {
            return false;
        }
        Map<Integer, AFServerSocket<?>> map = this.openServerSockets;
        synchronized (map) {
            return this.openServerSockets.containsKey(port);
        }
    }

    protected AFNaming getNaming() {
        return this.naming;
    }

    abstract boolean hasRegisteredPort(int var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class ServerSocketCloseable
    implements Closeable {
        private final int port;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServerSocketCloseable(AFServerSocket<?> socket, int port) {
            this.port = port;
            Map map = AFRMISocketFactory.this.openServerSockets;
            synchronized (map) {
                AFRMISocketFactory.this.openServerSockets.put(port, socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Map map = AFRMISocketFactory.this.openServerSockets;
            synchronized (map) {
                AFRMISocketFactory.this.openServerSockets.remove(this.port);
            }
        }
    }
}

