/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.ShutdownException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class AFUNIXRegistryAccess {
    AFUNIXRegistryAccess() {
    }

    public abstract AFUNIXRegistry getRegistry() throws RemoteException;

    public Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        return this.getRegistry().lookup(name);
    }

    public Remote lookup(String name, long timeout, TimeUnit unit) throws NotBoundException, MalformedURLException, RemoteException {
        return this.getRegistry().lookup(name, timeout, unit);
    }

    public void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        this.getRegistry().unbind(name);
    }

    public void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        this.getRegistry().bind(name, obj);
    }

    public void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        this.getRegistry().rebind(name, obj);
    }

    public String[] list() throws RemoteException, AccessException {
        try {
            return this.getRegistry().list();
        }
        catch (ShutdownException e) {
            return new String[0];
        }
    }
}

