/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectIOException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.rmi.AFUNIXNamingRef;
import org.newsclub.net.unix.rmi.AFUNIXRMIService;
import org.newsclub.net.unix.rmi.AFUNIXRMIServiceImpl;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.AFUNIXRegistry;
import org.newsclub.net.unix.rmi.AFUNIXRegistryAccess;
import org.newsclub.net.unix.rmi.ShutdownException;
import org.newsclub.net.unix.rmi.ShutdownHookSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXNaming
extends AFUNIXRegistryAccess {
    private static final String RMI_SERVICE_NAME = AFUNIXRMIService.class.getName();
    private static final String PROP_RMI_SOCKET_DIR = "org.newsclub.net.unix.rmi.socketdir";
    private static final File DEFAULT_SOCKET_DIRECTORY = new File(System.getProperty("org.newsclub.net.unix.rmi.socketdir", "/tmp"));
    private static final Map<AFUNIXNamingRef, AFUNIXNaming> INSTANCES = new HashMap<AFUNIXNamingRef, AFUNIXNaming>();
    private AFUNIXRegistry registry = null;
    private AFUNIXRMIService rmiService = null;
    private final File registrySocketDir;
    private final int registryPort;
    private final int servicePort;
    private final AFUNIXRMISocketFactory socketFactory;
    private boolean deleteRegistrySocketDir = false;
    private boolean remoteShutdownAllowed = true;
    private final AtomicBoolean shutdownInProgress = new AtomicBoolean(false);
    private final AtomicBoolean addedShutdownHook = new AtomicBoolean(false);

    private AFUNIXNaming(File socketDir, int port, String socketPrefix, String socketSuffix) throws IOException {
        this.registrySocketDir = socketDir;
        this.registryPort = port;
        this.servicePort = 100002;
        this.socketFactory = new AFUNIXRMISocketFactory(this, socketDir, null, null, socketPrefix, socketSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXNaming newPrivateInstance() throws IOException {
        File tmpDir = Files.createTempDirectory("junixsocket-", new FileAttribute[0]).toFile();
        if (!tmpDir.canWrite()) {
            throw new IOException("Could not create temporary directory: " + tmpDir);
        }
        AFUNIXNaming instance = AFUNIXNaming.getInstance(tmpDir, 100001);
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            instance.deleteRegistrySocketDir = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public static AFUNIXNaming getInstance() throws IOException {
        return AFUNIXNaming.getInstance(DEFAULT_SOCKET_DIRECTORY, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir, int registryPort) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, registryPort, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXNaming getInstance(File socketDir, int registryPort, String socketPrefix, String socketSuffix) throws RemoteException {
        Objects.requireNonNull(socketDir);
        AFUNIXNamingRef sap = new AFUNIXNamingRef(socketDir, registryPort, socketPrefix, socketSuffix);
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            AFUNIXNaming instance = INSTANCES.get(sap);
            if (instance == null) {
                try {
                    instance = new AFUNIXNaming(sap.socketDir, registryPort, socketPrefix, socketSuffix);
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
                INSTANCES.put(sap, instance);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return instance;
        }
    }

    public static AFUNIXNaming getSingleFileInstance(File socketFile) throws IOException {
        return AFUNIXNaming.getInstance(socketFile, Integer.MAX_VALUE);
    }

    public static File getDefaultSocketDirectory() {
        return DEFAULT_SOCKET_DIRECTORY;
    }

    public AFUNIXRMISocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public File getRegistrySocketDir() {
        return this.registrySocketDir;
    }

    public File getRegistrySocketFile() {
        return this.socketFactory.getFile(this.registryPort);
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    AFUNIXRMIService getRMIService() throws RemoteException, NotBoundException {
        return this.getRMIService(this.getRegistry());
    }

    AFUNIXRMIService getRMIService(AFUNIXRegistry reg) throws RemoteException, NotBoundException {
        if (this.rmiService == null) {
            this.rmiService = this.getRMIServiceFromRegistry(reg);
        }
        return this.rmiService;
    }

    AFUNIXRMIService getRMIServiceFromRegistry(AFUNIXRegistry reg) throws RemoteException, NotBoundException {
        AFUNIXRMIService service = (AFUNIXRMIService)reg.lookup(RMI_SERVICE_NAME, 5L, TimeUnit.SECONDS);
        this.remoteShutdownAllowed = service.isShutdownAllowed();
        return service;
    }

    private void closeUponRuntimeShutdown() {
        if (this.addedShutdownHook.compareAndSet(false, true)) {
            ShutdownHookSupport.addWeakShutdownHook(new ShutdownHookSupport.ShutdownHook(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onRuntimeShutdown(Thread thread) throws IOException {
                    Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
                    synchronized (AFUNIXNaming.class) {
                        if (AFUNIXNaming.this.registry != null && AFUNIXNaming.this.registry.isLocal()) {
                            AFUNIXNaming.this.shutdownRegistry();
                        }
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    private void rebindRMIService(AFUNIXRMIService assigner) throws RemoteException {
        this.rmiService = assigner;
        this.getRegistry().rebind(RMI_SERVICE_NAME, assigner);
    }

    @Override
    public AFUNIXRegistry getRegistry() throws RemoteException {
        return this.getRegistry(0L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFUNIXRegistry getRegistry(long timeout, TimeUnit unit) throws RemoteException {
        if (this.shutdownInProgress.get()) {
            throw new ShutdownException();
        }
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            AFUNIXRegistry reg = this.getRegistry(false);
            if (reg == null) {
                File socketFile = this.getRegistrySocketFile();
                if (!socketFile.exists() && this.waitUntilFileExists(socketFile, timeout, unit) && (reg = this.getRegistry(false)) != null) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return reg;
                }
                throw new ShutdownException("Could not find registry at " + this.getRegistrySocketFile());
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return reg;
        }
    }

    private boolean waitUntilFileExists(File f, long timeout, TimeUnit unit) {
        try {
            for (long timeWait = unit.toMillis(timeout); timeWait > 0L && !f.exists(); timeWait -= 50L) {
                Thread.sleep(Math.min(50L, timeWait));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFUNIXRegistry getRegistry(boolean create) throws RemoteException {
        if (this.shutdownInProgress.get()) {
            throw new ShutdownException();
        }
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            if (this.registry != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.registry;
            }
            if (!this.socketFactory.hasSocketFile(this.registryPort)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return create ? this.createRegistry() : null;
            }
            AFUNIXRegistry reg = this.locateRegistry();
            this.setRegistry(reg);
            try {
                this.getRMIService(reg);
            }
            catch (ConnectIOException | NoSuchObjectException | NotBoundException e) {
                if (create) {
                    this.setRegistry(null);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.createRegistry();
                }
                throw new ServerException("Could not access " + AFUNIXRMIService.class.getName(), e);
            }
            return this.registry;
        }
    }

    private AFUNIXRegistry locateRegistry() throws RemoteException {
        Registry regImpl = LocateRegistry.getRegistry(null, this.registryPort, this.socketFactory);
        return regImpl == null ? null : new AFUNIXRegistry(this, regImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRegistry() throws RemoteException {
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            if (this.registry == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            AFUNIXRegistry registryToBeClosed = this.registry;
            AFUNIXRMIService rmiServiceToBeClosed = this.rmiService;
            if (!registryToBeClosed.isLocal()) {
                if (!this.isRemoteShutdownAllowed()) {
                    throw new ServerException("The server refuses to be shutdown remotely");
                }
                this.setRegistry(null);
                try {
                    this.shutdownViaRMIService(registryToBeClosed, rmiServiceToBeClosed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.setRegistry(null);
            if (!this.shutdownInProgress.compareAndSet(false, true)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                this.unexportRMIService(registryToBeClosed, (AFUNIXRMIServiceImpl)rmiServiceToBeClosed);
                this.forceUnexportBound(registryToBeClosed);
                this.closeSocketFactory();
                this.deleteSocketDir();
            }
            finally {
                this.shutdownInProgress.set(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void unexportRMIService(AFUNIXRegistry reg, AFUNIXRMIServiceImpl serv) throws AccessException, RemoteException {
        if (serv != null) {
            serv.shutdownRegisteredCloseables();
        }
        try {
            if (serv != null) {
                AFUNIXNaming.unexportObject(serv);
            }
            reg.unbind(RMI_SERVICE_NAME);
        }
        catch (NotBoundException | ShutdownException exception) {
            // empty catch block
        }
        this.rmiService = null;
    }

    private void forceUnexportBound(AFUNIXRegistry reg) {
        try {
            reg.forceUnexportBound();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSocketFactory() {
        if (this.socketFactory != null) {
            try {
                this.socketFactory.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteSocketDir() {
        if (this.deleteRegistrySocketDir && this.registrySocketDir != null) {
            try {
                Files.delete(this.registrySocketDir.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void shutdownViaRMIService(AFUNIXRegistry reg, AFUNIXRMIService serv) throws RemoteException {
        try {
            if (serv == null) {
                serv = this.getRMIService(reg);
            }
            if (serv.isShutdownAllowed()) {
                serv.shutdown();
            }
        }
        catch (ConnectIOException | NotBoundException | ServerException exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFUNIXRegistry createRegistry() throws RemoteException {
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            AFUNIXRegistry existingRegistry = this.registry;
            if (existingRegistry == null) {
                try {
                    existingRegistry = this.getRegistry(false);
                }
                catch (ServerException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof NotBoundException || cause instanceof ConnectIOException) {
                        existingRegistry = null;
                    }
                    throw e;
                }
            }
            if (existingRegistry != null) {
                if (!this.isRemoteShutdownAllowed()) {
                    throw new ServerException("The server refuses to be shutdown remotely");
                }
                this.shutdownRegistry();
            }
            if (this.registrySocketDir != null && !this.registrySocketDir.mkdirs() && !this.registrySocketDir.isDirectory()) {
                throw new ServerException("Cannot create socket directory:" + this.registrySocketDir);
            }
            this.setRegistry(new AFUNIXRegistry(this, LocateRegistry.createRegistry(this.registryPort, this.socketFactory, this.socketFactory)));
            AFUNIXRMIServiceImpl service = new AFUNIXRMIServiceImpl(this);
            UnicastRemoteObject.exportObject(service, this.servicePort, this.socketFactory, this.socketFactory);
            this.rebindRMIService(service);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.registry;
        }
    }

    public boolean isRemoteShutdownAllowed() {
        return this.remoteShutdownAllowed;
    }

    public void setRemoteShutdownAllowed(boolean remoteShutdownAllowed) {
        this.remoteShutdownAllowed = remoteShutdownAllowed;
    }

    public void exportAndBind(String name, Remote obj) throws RemoteException, AlreadyBoundException {
        AFUNIXNaming.exportObject(obj, this.getSocketFactory());
        this.getRegistry().bind(name, obj);
    }

    public void exportAndRebind(String name, Remote obj) throws RemoteException {
        AFUNIXNaming.exportObject(obj, this.getSocketFactory());
        this.getRegistry().rebind(name, obj);
    }

    public void unexportAndUnbind(String name, Remote obj) throws RemoteException {
        AFUNIXNaming.unexportObject(obj);
        try {
            this.unbind(name);
        }
        catch (MalformedURLException | NotBoundException exception) {
            // empty catch block
        }
    }

    public static Remote exportObject(Remote obj, RMISocketFactory socketFactory) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, 0, socketFactory, socketFactory);
    }

    public static void unexportObject(Remote obj) {
        try {
            UnicastRemoteObject.unexportObject(obj, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRegistry(AFUNIXRegistry registry) {
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            this.registry = registry;
            if (registry == null) {
                this.rmiService = null;
            } else if (registry.isLocal()) {
                this.closeUponRuntimeShutdown();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

