/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.rmi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import org.newsclub.net.unix.rmi.AFUNIXRMISocketFactory;
import org.newsclub.net.unix.rmi.PortAssigner;
import org.newsclub.net.unix.rmi.PortAssignerImpl;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXNaming {
    private static final String PORT_ASSIGNER_ID = PortAssigner.class.getName();
    private static final String PROP_RMI_SOCKET_DIR = "org.newsclub.net.unix.rmi.socketdir";
    private static final File DEFAULT_SOCKET_DIRECTORY = new File(System.getProperty("org.newsclub.net.unix.rmi.socketdir", "/tmp"));
    private static final Map<SocketDirAndPort, AFUNIXNaming> INSTANCES = new HashMap<SocketDirAndPort, AFUNIXNaming>();
    private Registry registry = null;
    private PortAssigner portAssigner = null;
    private final File registrySocketDir;
    private final int registryPort;
    private AFUNIXRMISocketFactory socketFactory;

    private AFUNIXNaming(File socketDir, int port, String socketPrefix, String socketSuffix) throws IOException {
        this.registrySocketDir = socketDir;
        this.registryPort = port;
        this.socketFactory = new AFUNIXRMISocketFactory(this, socketDir, null, null, socketPrefix, socketSuffix);
    }

    public static AFUNIXNaming getInstance() throws IOException {
        return AFUNIXNaming.getInstance(DEFAULT_SOCKET_DIRECTORY, 100001);
    }

    public static AFUNIXNaming getInstance(File socketDir) throws RemoteException {
        return AFUNIXNaming.getInstance(socketDir, 100001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AFUNIXNaming getInstance(File socketDir, int registryPort) throws RemoteException {
        String socketPrefix = null;
        String socketSuffix = null;
        if (socketDir == null) {
            File tempFile;
            socketDir = DEFAULT_SOCKET_DIRECTORY;
            if (!socketDir.mkdirs() && !socketDir.isDirectory()) {
                throw new RemoteException("Cannot create directory for temporary file: " + socketDir);
            }
            try {
                tempFile = File.createTempFile("jux", "-", socketDir);
            }
            catch (IOException e) {
                throw new RemoteException("Cannot create temporary file: " + e.getMessage(), e);
            }
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
            socketPrefix = tempFile.getName();
        }
        SocketDirAndPort sap = new SocketDirAndPort(socketDir, registryPort);
        Class<AFUNIXNaming> clazz = AFUNIXNaming.class;
        synchronized (AFUNIXNaming.class) {
            AFUNIXNaming instance = INSTANCES.get(sap);
            if (instance == null) {
                try {
                    instance = new AFUNIXNaming(sap.socketDir, registryPort, socketPrefix, socketSuffix);
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new RemoteException(e.getMessage(), e);
                }
                INSTANCES.put(sap, instance);
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return instance;
        }
    }

    public static AFUNIXNaming getSingleFileInstance(File socketFile) throws IOException {
        return AFUNIXNaming.getInstance(socketFile, Integer.MAX_VALUE);
    }

    public AFUNIXRMISocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public File getRegistrySocketDir() {
        return this.registrySocketDir;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public PortAssigner getPortAssigner() throws RemoteException, NotBoundException {
        if (this.portAssigner != null) {
            return this.portAssigner;
        }
        this.portAssigner = this.getPortAssignerFromRegistry();
        return this.portAssigner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PortAssigner getPortAssignerFromRegistry() throws RemoteException, NotBoundException {
        Class<PortAssigner> clazz = PortAssigner.class;
        synchronized (PortAssigner.class) {
            PortAssigner assigner;
            try {
                assigner = (PortAssigner)this.lookup(PORT_ASSIGNER_ID);
            }
            catch (MalformedURLException e) {
                throw (RemoteException)new RemoteException(e.getMessage()).initCause(e);
            }
            return assigner;
        }
    }

    private void rebindPortAssigner(PortAssigner assigner) throws RemoteException {
        this.portAssigner = assigner;
        this.getRegistry().rebind(PORT_ASSIGNER_ID, assigner);
    }

    public Registry getRegistry() throws RemoteException {
        if (this.registry == null) {
            this.registry = LocateRegistry.getRegistry(null, this.registryPort, this.socketFactory);
        }
        return this.registry;
    }

    public Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        return this.getRegistry().lookup(name);
    }

    public void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        this.getRegistry().unbind(name);
    }

    public void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        this.getRegistry().bind(name, obj);
    }

    public void rebind(String name, Remote obj) throws MalformedURLException, RemoteException {
        this.getRegistry().rebind(name, obj);
    }

    public void shutdownRegistry() throws IOException {
        try {
            this.getRegistry().unbind(PORT_ASSIGNER_ID);
            UnicastRemoteObject.unexportObject(this.portAssigner, true);
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
        this.portAssigner = null;
        this.socketFactory.close();
        this.socketFactory = null;
    }

    public Registry createRegistry() throws RemoteException {
        if (this.registry != null) {
            throw new RemoteException("The Registry is already created: " + this.registry);
        }
        this.registry = LocateRegistry.createRegistry(this.registryPort, this.socketFactory, this.socketFactory);
        PortAssignerImpl ass = new PortAssignerImpl();
        UnicastRemoteObject.exportObject(ass, 100002, this.socketFactory, this.socketFactory);
        this.rebindPortAssigner(ass);
        return this.registry;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SocketDirAndPort {
        File socketDir;
        int port;

        public SocketDirAndPort(File socketDir, int port) throws RemoteException {
            try {
                this.socketDir = socketDir.getCanonicalFile();
            }
            catch (IOException e) {
                throw (RemoteException)new RemoteException(e.getMessage()).initCause(e);
            }
            this.port = port;
        }

        public int hashCode() {
            return this.socketDir == null ? this.port : this.socketDir.hashCode() ^ this.port;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SocketDirAndPort) {
                SocketDirAndPort other = (SocketDirAndPort)obj;
                if (this.port != other.port) {
                    return false;
                }
                if (this.socketDir == null) {
                    return other.socketDir == null;
                }
                return this.socketDir.equals(other.socketDir);
            }
            return false;
        }
    }
}

