/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.jetty;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Path;
import java.util.EventListener;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Scheduler;
import org.newsclub.net.unix.AFServerSocketChannel;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ManagedObject
public class AFSocketServerConnector
extends AbstractConnector {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConnector.class);
    private final AtomicReference<Closeable> acceptor;
    private final SelectorManager selectorManager;
    private ServerSocketChannel serverChannel;
    private AFSocketAddress listenSocketAddress;
    private boolean inheritChannel;
    private int acceptQueueSize;
    private int acceptedReceiveBufferSize;
    private int acceptedSendBufferSize;
    private boolean mayStopServer;
    private boolean mayStopServerForce;
    private final Class<? extends EventListener> selectorManagerListenerClass;
    private final Server server;

    public AFSocketServerConnector(Server server, ConnectionFactory ... factories) {
        this(server, null, null, null, -1, -1, factories);
    }

    public AFSocketServerConnector(Server server, int acceptors, int selectors, ConnectionFactory ... factories) {
        this(server, null, null, null, acceptors, selectors, factories);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AFSocketServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        ConnectionFactory[] connectionFactoryArray;
        if (factories.length > 0) {
            connectionFactoryArray = factories;
        } else {
            ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[1];
            connectionFactoryArray = connectionFactoryArray2;
            connectionFactoryArray2[0] = new HttpConnectionFactory();
        }
        super(server, executor, scheduler, pool, acceptors, connectionFactoryArray);
        this.acceptor = new AtomicReference();
        this.mayStopServer = false;
        this.mayStopServerForce = false;
        this.server = server;
        this.selectorManager = this.newSelectorManager(this.getExecutor(), this.getScheduler(), selectors);
        this.addBean(this.selectorManager, true);
        this.selectorManagerListenerClass = AFSocketServerConnector.findSelectorManagerListenerClass();
    }

    private static Class<? extends EventListener> findSelectorManagerListenerClass() {
        try {
            return Class.forName("org.eclipse.jetty.io.SelectorManager$SelectorManagerListener");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private SelectorManager newSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        return new AFSocketSelectorManager(executor, scheduler, selectors);
    }

    @ManagedAttribute(value="The Unix-Domain path this connector listens to")
    @Deprecated
    public Path getUnixDomainPath() {
        AFUNIXSocketAddress addr;
        if (this.listenSocketAddress instanceof AFUNIXSocketAddress && (addr = (AFUNIXSocketAddress)this.listenSocketAddress).hasFilename()) {
            try {
                return addr.getFile().toPath();
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public void setUnixDomainPath(Path unixDomainPath) {
        try {
            this.listenSocketAddress = AFUNIXSocketAddress.of((Path)unixDomainPath);
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
    }

    @ManagedAttribute(value="The socket address this connector listens to")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AFSocketAddress getListenSocketAddress() {
        return this.listenSocketAddress;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setListenSocketAddress(AFSocketAddress addr) {
        this.listenSocketAddress = addr;
    }

    @ManagedAttribute(value="Whether this connector uses a server channel inherited from the JVM")
    public boolean isInheritChannel() {
        return this.inheritChannel;
    }

    public void setInheritChannel(boolean inheritChannel) {
        this.inheritChannel = inheritChannel;
    }

    @ManagedAttribute(value="The accept queue size (backlog) for the server socket")
    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this.acceptQueueSize = acceptQueueSize;
    }

    @ManagedAttribute(value="The SO_RCVBUF option for accepted sockets")
    public int getAcceptedReceiveBufferSize() {
        return this.acceptedReceiveBufferSize;
    }

    public void setAcceptedReceiveBufferSize(int acceptedReceiveBufferSize) {
        this.acceptedReceiveBufferSize = acceptedReceiveBufferSize;
    }

    @ManagedAttribute(value="The SO_SNDBUF option for accepted sockets")
    public int getAcceptedSendBufferSize() {
        return this.acceptedSendBufferSize;
    }

    public void setAcceptedSendBufferSize(int acceptedSendBufferSize) {
        this.acceptedSendBufferSize = acceptedSendBufferSize;
    }

    protected void doStart() throws Exception {
        if (this.selectorManagerListenerClass != null) {
            this.getBeans(this.selectorManagerListenerClass).forEach(arg_0 -> ((SelectorManager)this.selectorManager).addEventListener(arg_0));
        }
        this.serverChannel = this.open();
        this.addBean(this.serverChannel);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.serverChannel);
        this.close();
        if (this.selectorManagerListenerClass != null) {
            this.getBeans(this.selectorManagerListenerClass).forEach(arg_0 -> ((SelectorManager)this.selectorManager).removeEventListener(arg_0));
        }
    }

    protected void accept(int acceptorID) throws IOException {
        ServerSocketChannel sc = this.serverChannel;
        if (sc != null) {
            try {
                SocketChannel channel = sc.accept();
                this.accepted(channel);
            }
            catch (SocketException e) {
                boolean takenOver;
                boolean bl = takenOver = !sc.isOpen() || sc.getLocalAddress() == null;
                if (!takenOver && sc instanceof AFServerSocketChannel) {
                    boolean bl2 = takenOver = !((AFServerSocketChannel)sc).isLocalSocketAddressValid();
                }
                if (takenOver && this.isMayStopServer()) {
                    LOG.warn("Another server has taken over our address");
                    ForkJoinPool.commonPool().execute(this::checkServerStop);
                }
                throw (ClosedByInterruptException)new ClosedByInterruptException().initCause(e);
            }
        }
    }

    private void checkServerStop() {
        Connector[] connectors = this.server.getConnectors();
        if (connectors != null && !this.isMayStopServerForce()) {
            for (Connector conn : connectors) {
                if (conn == this || !conn.isRunning()) continue;
                return;
            }
        }
        LOG.warn("Server has no other connectors; shutting down: " + this.server);
        try {
            this.server.stop();
        }
        catch (Exception e1) {
            LOG.warn("Exception upon stopping " + this.server, (Throwable)e1);
        }
    }

    private void accepted(SocketChannel channel) throws IOException {
        channel.configureBlocking(false);
        this.configure(channel);
        this.selectorManager.accept((SelectableChannel)channel);
    }

    protected void configure(SocketChannel channel) throws IOException {
        int sndBufSize;
        channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        int rcvBufSize = this.getAcceptedReceiveBufferSize();
        if (rcvBufSize > 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)rcvBufSize);
        }
        if ((sndBufSize = this.getAcceptedSendBufferSize()) > 0) {
            channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)sndBufSize);
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Object getTransport() {
        return this.serverChannel;
    }

    private ServerSocketChannel open() throws IOException {
        ServerSocketChannel sc = this.openServerSocketChannel();
        if (this.getAcceptors() == 0) {
            sc.configureBlocking(false);
            this.acceptor.set(this.selectorManager.acceptor((SelectableChannel)sc));
        }
        return sc;
    }

    private void close() throws IOException {
        ServerSocketChannel sc = this.serverChannel;
        this.serverChannel = null;
        IO.close((Closeable)sc);
    }

    private ServerSocketChannel openServerSocketChannel() throws IOException {
        ServerSocketChannel sc = null;
        if (this.isInheritChannel()) {
            Channel channel = System.inheritedChannel();
            if (channel instanceof ServerSocketChannel) {
                sc = (ServerSocketChannel)channel;
            } else {
                LOG.warn("Unable to use System.inheritedChannel() {}. Trying a new ServerSocketChannel at {}", (Object)channel, (Object)this.getListenSocketAddress());
            }
        }
        if (sc == null) {
            sc = this.bindServerSocketChannel();
        }
        return sc;
    }

    private ServerSocketChannel bindServerSocketChannel() throws IOException {
        AFSocketAddress socketAddress = this.listenSocketAddress;
        AFServerSocketChannel sc = socketAddress.getAddressFamily().newServerSocketChannel();
        try {
            sc.bind((SocketAddress)socketAddress, this.getAcceptQueueSize());
            return sc;
        }
        catch (IOException x) {
            String message = String.format(Locale.ENGLISH, "Could not bind %s to %s", AFSocketServerConnector.class.getSimpleName(), this.listenSocketAddress);
            throw new IOException(message, x);
        }
    }

    public void setAccepting(boolean accepting) {
        super.setAccepting(accepting);
        if (this.getAcceptors() == 0) {
            return;
        }
        if (accepting) {
            Closeable cl;
            if (this.acceptor.get() == null && !this.acceptor.compareAndSet(null, cl = this.selectorManager.acceptor((SelectableChannel)this.serverChannel))) {
                IO.close((Closeable)cl);
            }
        } else {
            Closeable cl = this.acceptor.get();
            if (cl != null && this.acceptor.compareAndSet(cl, null)) {
                IO.close((Closeable)cl);
            }
        }
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s@%h[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.listenSocketAddress);
    }

    @ManagedAttribute(value="Whether this connector may stop the server when it's no longer able to serve and no other connectors are available")
    public boolean isMayStopServer() {
        return this.mayStopServer;
    }

    public void setMayStopServer(boolean mayStopServer) {
        this.mayStopServer = mayStopServer;
    }

    @ManagedAttribute(value="Whether this connector may stop the server when it's no longer able to serve, even if other connectors are available")
    public boolean isMayStopServerForce() {
        return this.mayStopServerForce;
    }

    public void setMayStopServerForce(boolean b) {
        if (b) {
            this.setMayStopServer(true);
        }
        this.mayStopServerForce = b;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class AFSocketSelectorManager
    extends SelectorManager {
        public AFSocketSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected Selector newSelector() throws IOException {
            SelectorProvider provider = AFSocketServerConnector.this.listenSocketAddress.getAddressFamily().getSelectorProvider();
            return provider.openSelector();
        }

        protected void accepted(SelectableChannel channel) throws IOException {
            AFSocketServerConnector.this.accepted((SocketChannel)channel);
        }

        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) {
            SocketChannelEndPoint endPoint = new SocketChannelEndPoint((SocketChannel)channel, selector, selectionKey, this.getScheduler());
            endPoint.setIdleTimeout(AFSocketServerConnector.this.getIdleTimeout());
            return endPoint;
        }

        public Connection newConnection(SelectableChannel channel, EndPoint endpoint, Object attachment) {
            return AFSocketServerConnector.this.getDefaultConnectionFactory().newConnection((Connector)AFSocketServerConnector.this, endpoint);
        }

        protected void endPointOpened(EndPoint endpoint) {
            super.endPointOpened(endpoint);
            AFSocketServerConnector.this.onEndPointOpened(endpoint);
        }

        protected void endPointClosed(EndPoint endpoint) {
            AFSocketServerConnector.this.onEndPointClosed(endpoint);
            super.endPointClosed(endpoint);
        }
    }
}

