/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo.nanohttpd;

import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.demo.DemoHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class NanoHttpdServerDemo
extends NanoHTTPD {
    public NanoHttpdServerDemo(final SocketAddress socketAddress) throws IOException {
        super(0);
        this.setServerSocketFactory(new NanoHTTPD.ServerSocketFactory(){

            public ServerSocket create() throws IOException {
                if (socketAddress instanceof AFSocketAddress) {
                    return ((AFSocketAddress)socketAddress).newForceBoundServerSocket();
                }
                ServerSocket serverSocket = new ServerSocket();
                serverSocket.bind(socketAddress);
                return serverSocket;
            }
        });
        System.out.println("Address: " + socketAddress);
        if (socketAddress instanceof AFUNIXSocketAddress) {
            System.out.println("Try: curl --unix-socket " + ((AFUNIXSocketAddress)socketAddress).getPath() + " http://localhost/");
        }
    }

    public static void main(String[] args) throws IOException {
        SocketAddress addr = DemoHelper.parseAddress(args, (SocketAddress)AFUNIXSocketAddress.of((File)new File("/tmp/junixsocket-http-server.sock")));
        new NanoHttpdServerDemo(addr).start(5000, false);
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        return NanoHttpdServerDemo.newFixedLengthResponse((String)("Hello world from " + NanoHttpdServerDemo.getSystemHostname() + "\n"));
    }

    private static String getSystemHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

