/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix.demo;

import java.util.Properties;
import java.util.function.Function;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DemoHelper {
    private DemoHelper() {
        throw new IllegalStateException("No instances");
    }

    public static void addProperty(Properties props, String key, String defaultValue, String property, String exampleValue) {
        String value = defaultValue;
        if (property == null) {
            System.out.println(key + "=" + value);
        } else {
            value = System.getProperty(property, value);
            Object example = exampleValue == null ? "" : "=" + exampleValue + " (for example)";
            System.out.println(key + "=" + value + " -- override with -D" + property + (String)example);
        }
        props.setProperty(key, value);
    }

    public static void initJDBCDriverClass(String property, String defaultValue, String exampleValue) throws ClassNotFoundException {
        exampleValue = exampleValue == null ? "(...)" : (String)exampleValue + " (for example)";
        String driverClass = System.getProperty(property, defaultValue);
        if (driverClass.isEmpty()) {
            System.out.println("Using JDBC driver provided by SPI -- override with -D" + property + "=" + (String)exampleValue);
        } else {
            if (driverClass.equals(defaultValue)) {
                System.out.println("Using JDBC default driver " + driverClass + " -- override with -D" + property + "=" + (String)exampleValue);
            } else {
                System.out.println("Using JDBC driver provided by -D" + property + "=" + driverClass);
            }
            Class.forName(driverClass);
        }
    }

    public static String getPropertyValue(String property, String defaultValue, String exampleValue) {
        return DemoHelper.getPropertyValue(property, property, defaultValue, exampleValue, null);
    }

    public static String getPropertyValue(String property, String defaultValue, String exampleValue, Function<String, String> valueConverter) {
        return DemoHelper.getPropertyValue(property, property, defaultValue, exampleValue, valueConverter);
    }

    public static String getPropertyValue(String variable, String property, String defaultValue, String exampleValue, Function<String, String> valueConverter) {
        boolean print = true;
        if (exampleValue == null) {
            print = false;
        } else if (((String)exampleValue).isEmpty()) {
            exampleValue = "(...)";
        } else {
            if (((String)exampleValue).contains("$")) {
                exampleValue = "'" + (String)exampleValue + "'";
            }
            exampleValue = (String)exampleValue + " (for example)";
        }
        String value = System.getProperty(property, defaultValue);
        if (valueConverter != null) {
            value = valueConverter.apply(value);
        }
        if (print) {
            if (defaultValue.equals(exampleValue)) {
                System.out.println(variable + "=" + value + " -- override with -D" + property + "=(...)");
            } else {
                System.out.println(variable + "=" + value + " -- override with -D" + property + "=" + (String)exampleValue);
            }
        }
        return value;
    }
}

