/*
 * Decompiled with CFR 0.152.
 */
package com.klinker.android.link_builder;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.widget.TextView;
import com.klinker.android.link_builder.Link;
import com.klinker.android.link_builder.TouchableMovementMethod;
import com.klinker.android.link_builder.TouchableSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 )2\u00020\u0001:\u0002)*B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0017\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000eJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0002J \u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u0004\u0018\u00010\u0012J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000bJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010(\u001a\u00020\u0016H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/klinker/android/link_builder/LinkBuilder;", "", "type", "", "(I)V", "textView", "Landroid/widget/TextView;", "(Landroid/widget/TextView;)V", "context", "Landroid/content/Context;", "findOnlyFirstMatch", "", "links", "Ljava/util/ArrayList;", "Lcom/klinker/android/link_builder/Link;", "spannable", "Landroid/text/SpannableString;", "text", "", "addLink", "link", "addLinkMovementMethod", "", "addLinkToSpan", "s", "Landroid/text/Spannable;", "addLinks", "", "addLinksFromPattern", "linkWithPattern", "applyAppendedAndPrependedText", "applyLink", "range", "Lcom/klinker/android/link_builder/LinkBuilder$Range;", "build", "setContext", "setFindOnlyFirstMatchesForAnyLink", "findOnlyFirst", "setText", "setTextView", "turnPatternsToLinks", "Companion", "Range", "library_release"})
public final class LinkBuilder {
    private Context context;
    private final int type;
    private final ArrayList<Link> links = new ArrayList();
    private TextView textView;
    private CharSequence text;
    private boolean findOnlyFirstMatch;
    private SpannableString spannable;
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_TEXT_VIEW = 2;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LinkBuilder setTextView(@NotNull TextView textView) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        this.textView = textView;
        CharSequence charSequence = textView.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"textView.text");
        return this.setText(charSequence);
    }

    @NotNull
    public final LinkBuilder setText(@NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        return this;
    }

    @NotNull
    public final LinkBuilder setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        return this;
    }

    @NotNull
    public final LinkBuilder setFindOnlyFirstMatchesForAnyLink(boolean findOnlyFirst) {
        this.findOnlyFirstMatch = findOnlyFirst;
        return this;
    }

    @NotNull
    public final LinkBuilder addLink(@NotNull Link link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        this.links.add(link);
        return this;
    }

    @NotNull
    public final LinkBuilder addLinks(@NotNull List<Link> links) {
        Intrinsics.checkParameterIsNotNull(links, (String)"links");
        if (links.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("link list is empty");
        }
        this.links.addAll((Collection<Link>)links);
        return this;
    }

    @Nullable
    public final CharSequence build() {
        this.turnPatternsToLinks();
        if (this.links.size() == 0) {
            return null;
        }
        this.applyAppendedAndPrependedText();
        Iterator<Link> iterator = this.links.iterator();
        while (iterator.hasNext()) {
            Link link;
            Link link2 = link = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)link2, (String)"link");
            this.addLinkToSpan(link2);
        }
        if (this.type == 2) {
            TextView textView = this.textView;
            if (textView == null) {
                Intrinsics.throwNpe();
            }
            textView.setText((CharSequence)this.spannable);
            this.addLinkMovementMethod();
        }
        return (CharSequence)this.spannable;
    }

    private final void addLinkToSpan(Link link) {
        if (this.spannable == null) {
            this.spannable = SpannableString.valueOf((CharSequence)this.text);
        }
        SpannableString spannableString = this.spannable;
        if (spannableString == null) {
            Intrinsics.throwNpe();
        }
        this.addLinkToSpan((Spannable)spannableString, link);
    }

    private final void addLinkToSpan(Spannable s, Link link) {
        Pattern pattern = Pattern.compile(Pattern.quote(link.text));
        CharSequence charSequence = this.text;
        if (charSequence == null) {
            Intrinsics.throwNpe();
        }
        Matcher matcher = pattern.matcher(charSequence);
        while (matcher.find()) {
            int start = matcher.start();
            if (start >= 0 && link.text != null) {
                String string = link.text;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                int end = start + string.length();
                this.applyLink(link, new Range(start, end), s);
            }
            if (!this.findOnlyFirstMatch) continue;
            break;
        }
    }

    private final void addLinkMovementMethod() {
        MovementMethod m;
        if (this.textView == null) {
            return;
        }
        TextView textView = this.textView;
        if (textView == null) {
            Intrinsics.throwNpe();
        }
        if ((m = textView.getMovementMethod()) == null || !(m instanceof TouchableMovementMethod)) {
            TextView textView2 = this.textView;
            if (textView2 == null) {
                Intrinsics.throwNpe();
            }
            if (textView2.getLinksClickable()) {
                TextView textView3 = this.textView;
                if (textView3 == null) {
                    Intrinsics.throwNpe();
                }
                textView3.setMovementMethod(TouchableMovementMethod.Companion.getInstance());
            }
        }
    }

    private final void applyLink(Link link, Range range, Spannable text) {
        TouchableSpan[] existingSpans = (TouchableSpan[])text.getSpans(range.getStart(), range.getEnd(), TouchableSpan.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)existingSpans, (String)"existingSpans");
        TouchableSpan[] touchableSpanArray = existingSpans;
        if (touchableSpanArray.length == 0) {
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwNpe();
            }
            TouchableSpan span = new TouchableSpan(context, link);
            text.setSpan((Object)span, range.getStart(), range.getEnd(), 33);
        } else {
            boolean newSpanConsumesAllOld = true;
            for (TouchableSpan span : existingSpans) {
                SpannableString spannableString = this.spannable;
                if (spannableString == null) {
                    Intrinsics.throwNpe();
                }
                int start = spannableString.getSpanStart((Object)span);
                SpannableString spannableString2 = this.spannable;
                if (spannableString2 == null) {
                    Intrinsics.throwNpe();
                }
                int end = spannableString2.getSpanEnd((Object)span);
                if (range.getStart() > start || range.getEnd() < end) {
                    newSpanConsumesAllOld = false;
                    break;
                }
                text.removeSpan((Object)span);
            }
            if (newSpanConsumesAllOld) {
                TouchableSpan span;
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwNpe();
                }
                span = new TouchableSpan(context, link);
                text.setSpan((Object)span, range.getStart(), range.getEnd(), 33);
            }
        }
    }

    private final void turnPatternsToLinks() {
        int size = this.links.size();
        int i = 0;
        while (i < size) {
            if (this.links.get((int)i).pattern != null) {
                Link link = this.links.get(i);
                Intrinsics.checkExpressionValueIsNotNull((Object)link, (String)"links[i]");
                this.addLinksFromPattern(link);
                this.links.remove(i);
                --size;
                continue;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyAppendedAndPrependedText() {
        int n = 0;
        int n2 = ((Collection)this.links).size();
        while (n < n2) {
            String totalText;
            void i;
            Link link = this.links.get((int)i);
            if (link.prependedText != null) {
                totalText = link.prependedText + " " + link.text;
                this.text = TextUtils.replace((CharSequence)this.text, (String[])new String[]{link.text}, (CharSequence[])new String[]{totalText});
                this.links.get((int)i).setText(totalText);
            }
            if (link.appendedText != null) {
                totalText = link.text + " " + link.text;
                this.text = TextUtils.replace((CharSequence)this.text, (String[])new String[]{link.text}, (CharSequence[])new String[]{totalText});
                this.links.get((int)i).setText(totalText);
            }
            ++i;
        }
    }

    private final void addLinksFromPattern(Link linkWithPattern) {
        Object object;
        block7: {
            block6: {
                Pattern pattern = linkWithPattern.pattern;
                object = pattern;
                if (object == null) break block6;
                CharSequence charSequence = this.text;
                if (charSequence == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = ((Pattern)object).matcher(charSequence)) != null) break block7;
            }
            return;
        }
        Object m = object;
        while (((Matcher)m).find()) {
            Link link = new Link(linkWithPattern);
            CharSequence charSequence = this.text;
            if (charSequence == null) {
                Intrinsics.throwNpe();
            }
            this.links.add(link.setText(((Object)charSequence.subSequence(((Matcher)m).start(), ((Matcher)m).end())).toString()));
            if (!this.findOnlyFirstMatch) continue;
            break;
        }
    }

    private LinkBuilder(int type) {
        this.type = type;
    }

    @Deprecated(message="")
    public LinkBuilder(@Nullable TextView textView) {
        if (textView == null) {
            throw (Throwable)new IllegalArgumentException("textView is null");
        }
        this.textView = textView;
        this.type = -1;
        this.setText(((Object)textView.getText()).toString());
    }

    public /* synthetic */ LinkBuilder(int type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @JvmStatic
    @NotNull
    public static final LinkBuilder from(@NotNull Context context, @NotNull CharSequence text) {
        return Companion.from(context, text);
    }

    @JvmStatic
    @NotNull
    public static final LinkBuilder on(@NotNull TextView tv) {
        return Companion.on(tv);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/klinker/android/link_builder/LinkBuilder$Range;", "", "start", "", "end", "(II)V", "getEnd", "()I", "setEnd", "(I)V", "getStart", "setStart", "library_release"})
    private static final class Range {
        private int start;
        private int end;

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/klinker/android/link_builder/LinkBuilder$Companion;", "", "()V", "TYPE_TEXT", "", "TYPE_TEXT_VIEW", "from", "Lcom/klinker/android/link_builder/LinkBuilder;", "context", "Landroid/content/Context;", "text", "", "on", "tv", "Landroid/widget/TextView;", "library_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LinkBuilder from(@NotNull Context context, @NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            return new LinkBuilder(1, null).setContext(context).setText(text);
        }

        @JvmStatic
        @NotNull
        public final LinkBuilder on(@NotNull TextView tv) {
            Intrinsics.checkParameterIsNotNull((Object)tv, (String)"tv");
            LinkBuilder linkBuilder = new LinkBuilder(2, null);
            Context context = tv.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"tv.context");
            return linkBuilder.setContext(context).setTextView(tv);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

