/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.klaytn.caver.utils.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Bytes;
import org.web3j.utils.Numeric;

public class SignatureData {
    private String v;
    private String r;
    private String s;

    public SignatureData(String v, String r, String s) {
        this.v = v;
        this.r = r;
        this.s = s;
    }

    public SignatureData(byte[] v, byte[] r, byte[] s) {
        this.v = Numeric.toHexString((byte[])v);
        this.r = Numeric.toHexString((byte[])r);
        this.s = Numeric.toHexString((byte[])s);
    }

    public static SignatureData getEmptySignature() {
        SignatureData emptySig = new SignatureData("0x01", "0x", "0x");
        return emptySig;
    }

    public static List<SignatureData> decodeSignatures(List<RlpType> signatureRlpTypeList) {
        ArrayList<SignatureData> signatureDataList = new ArrayList<SignatureData>();
        for (RlpType signature : signatureRlpTypeList) {
            List vrs = ((RlpList)signature).getValues();
            if (vrs.size() < 3) continue;
            byte[] v = ((RlpString)vrs.get(0)).getBytes();
            byte[] r = ((RlpString)vrs.get(1)).getBytes();
            byte[] s = ((RlpString)vrs.get(2)).getBytes();
            signatureDataList.add(new SignatureData(v, r, s));
        }
        return signatureDataList;
    }

    public void makeEIP155Signature(int chainId) {
        if (this.getV() == null || this.getV().isEmpty() || this.getV().equals("0x")) {
            throw new IllegalArgumentException("V value must be set.");
        }
        int v = Numeric.toBigInt((String)this.getV()).intValue();
        v = v + chainId * 2 + 8;
        this.setV(Numeric.toHexStringWithPrefix((BigInteger)BigInteger.valueOf(v)));
    }

    public RlpList toRlpList() {
        byte[] v = Numeric.hexStringToByteArray((String)this.getV());
        byte[] r = Numeric.hexStringToByteArray((String)this.getR());
        byte[] s = Numeric.hexStringToByteArray((String)this.getS());
        return new RlpList(new RlpType[]{RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])v)), RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])r)), RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])s))});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureData that = (SignatureData)o;
        if (!this.v.equals(that.v)) {
            return false;
        }
        if (!this.r.equals(that.r)) {
            return false;
        }
        return this.s.equals(that.s);
    }

    public int hashCode() {
        int result = this.v.hashCode();
        result = 31 * result + this.r.hashCode();
        result = 31 * result + this.s.hashCode();
        return result;
    }

    public String toString() {
        return "V : " + this.getV() + "\nR : " + this.getR() + "\nS : " + this.getS();
    }

    @JsonIgnore
    public String getV() {
        return this.v;
    }

    @JsonIgnore
    public String getR() {
        return this.r;
    }

    @JsonIgnore
    public String getS() {
        return this.s;
    }

    @JsonProperty(value="v")
    public String getTrimZeroV() {
        String v = Utils.stripHexPrefix(this.getV());
        v = v.replaceFirst("^0+(?!$)", "");
        return Utils.addHexPrefix(v);
    }

    @JsonProperty(value="r")
    public String getTrimZeroR() {
        String r = Utils.stripHexPrefix(this.getR());
        r = r.replaceFirst("^0+(?!$)", "");
        return Utils.addHexPrefix(r);
    }

    @JsonProperty(value="s")
    public String getTrimZeroS() {
        String s = Utils.stripHexPrefix(this.getS());
        s = s.replaceFirst("^0+(?!$)", "");
        return Utils.addHexPrefix(s);
    }

    public void setV(String v) {
        this.v = v;
    }

    public void setR(String r) {
        this.r = r;
    }

    public void setS(String s) {
        this.s = s;
    }
}

