/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.klaytn.caver.account.Account;
import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.account.WeightedMultiSigOptions;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.AbstractKeyring;
import com.klaytn.caver.wallet.keyring.KeyStore;
import com.klaytn.caver.wallet.keyring.KeyStoreOption;
import com.klaytn.caver.wallet.keyring.MessageSigned;
import com.klaytn.caver.wallet.keyring.PrivateKey;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.web3j.crypto.CipherException;

public class RoleBasedKeyring
extends AbstractKeyring {
    List<PrivateKey[]> keys;

    public RoleBasedKeyring(String address, List<PrivateKey[]> keys) {
        super(address);
        this.keys = keys;
    }

    @Override
    public List<SignatureData> sign(String txHash, int chainId, int role) {
        PrivateKey[] keyArr = this.getKeyByRole(role);
        return Arrays.stream(keyArr).map(key -> key.sign(txHash, chainId)).collect(Collectors.toList());
    }

    @Override
    public SignatureData sign(String txHash, int chainId, int role, int index) {
        PrivateKey[] keyArr = this.getKeyByRole(role);
        this.validatedIndexWithKeys(index, keyArr.length);
        PrivateKey key = keyArr[index];
        SignatureData signatureData = key.sign(txHash, chainId);
        return signatureData;
    }

    @Override
    public MessageSigned signMessage(String message, int role) {
        PrivateKey[] keyArr = this.getKeyByRole(role);
        String messageHash = Utils.hashMessage(message);
        List signatureDataList = Arrays.stream(keyArr).map(key -> key.signMessage(messageHash)).collect(Collectors.toCollection(ArrayList::new));
        MessageSigned signed = new MessageSigned(messageHash, signatureDataList, message);
        return signed;
    }

    @Override
    public MessageSigned signMessage(String message, int role, int index) {
        PrivateKey[] keyArr = this.getKeyByRole(role);
        this.validatedIndexWithKeys(index, keyArr.length);
        PrivateKey key = keyArr[index];
        String messageHash = Utils.hashMessage(message);
        SignatureData signatureData = key.signMessage(messageHash);
        MessageSigned signed = new MessageSigned(messageHash, Arrays.asList(signatureData), message);
        return signed;
    }

    @Override
    public KeyStore encrypt(String password, KeyStoreOption options) throws CipherException {
        ArrayList<List<KeyStore.Crypto>> cryptoList = new ArrayList<List<KeyStore.Crypto>>();
        for (int i = 0; i < AccountKeyRoleBased.ROLE_GROUP_COUNT; ++i) {
            PrivateKey[] privateKeys = this.keys.get(i);
            List<KeyStore.Crypto> list = KeyStore.Crypto.createCrypto(privateKeys, password, options);
            cryptoList.add(list);
        }
        KeyStore keyStore = new KeyStore();
        keyStore.setAddress(this.address);
        keyStore.setKeyring(cryptoList);
        keyStore.setVersion(4);
        keyStore.setId(UUID.randomUUID().toString());
        return keyStore;
    }

    @Override
    public AbstractKeyring copy() {
        return new RoleBasedKeyring(this.address, this.keys);
    }

    public List<String[]> getPublicKey() {
        return this.getPublicKey(false);
    }

    public List<String[]> getPublicKey(boolean compressed) {
        return this.keys.stream().map(array -> (String[])Arrays.stream(array).map(privateKey -> privateKey.getPublicKey(compressed)).toArray(String[]::new)).collect(Collectors.toCollection(ArrayList::new));
    }

    public PrivateKey[] getKeyByRole(int role) {
        if (role < 0 || role >= AccountKeyRoleBased.ROLE_GROUP_COUNT) {
            throw new IllegalArgumentException("Invalid role index : " + role);
        }
        PrivateKey[] keyArr = this.keys.get(role);
        if (keyArr.length == 0 && role > AccountKeyRoleBased.RoleGroup.TRANSACTION.getIndex()) {
            if (this.keys.get(AccountKeyRoleBased.RoleGroup.TRANSACTION.getIndex()).length == 0) {
                throw new IllegalArgumentException("The Key with specified role group does not exists. The TRANSACTION role group is also empty");
            }
            keyArr = this.keys.get(AccountKeyRoleBased.RoleGroup.TRANSACTION.getIndex());
        }
        return keyArr;
    }

    public Account toAccount() {
        List<WeightedMultiSigOptions> options = WeightedMultiSigOptions.getDefaultOptionsForRoleBased(this.getPublicKey());
        return this.toAccount(options);
    }

    public Account toAccount(List<WeightedMultiSigOptions> options) {
        return Account.createWithAccountKeyRoleBased(this.address, this.getPublicKey(), options);
    }

    public List<PrivateKey[]> getKeys() {
        return this.keys;
    }
}

