/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.klaytn.caver.utils.BytesUtils;
import com.klaytn.caver.utils.Utils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigInteger;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class PrivateKey {
    static final int LEN_UNCOMPRESSED_PUBLIC_KEY_STRING = 128;
    private String privateKey;

    public PrivateKey(String privateKey) {
        if (!Utils.isValidPrivateKey(privateKey)) {
            throw new IllegalArgumentException("Invalid private key.");
        }
        this.privateKey = Numeric.prependHexPrefix((String)privateKey);
    }

    public static PrivateKey generate() {
        return PrivateKey.generate(null);
    }

    public static PrivateKey generate(String entropy) {
        byte[] random = Utils.generateRandomBytes(32);
        byte[] entropyArr = entropy == null || entropy.isEmpty() ? Utils.generateRandomBytes(32) : Numeric.hexStringToByteArray((String)entropy);
        byte[] innerHex = Hash.sha3((byte[])BytesUtils.concat(random, entropyArr));
        byte[] middleHex = BytesUtils.concat(BytesUtils.concat(Utils.generateRandomBytes(32), innerHex), Utils.generateRandomBytes(32));
        String outerHex = Numeric.toHexString((byte[])Hash.sha3((byte[])middleHex));
        return new PrivateKey(outerHex);
    }

    public SignatureData sign(String sigHash, int chainId) {
        ECKeyPair keyPair = ECKeyPair.create((BigInteger)Numeric.toBigInt((String)this.privateKey));
        Sign.SignatureData signatureData = Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)sigHash), (ECKeyPair)keyPair, (boolean)false);
        SignatureData signData = new SignatureData(signatureData.getV(), signatureData.getR(), signatureData.getS());
        signData.makeEIP155Signature(chainId);
        return signData;
    }

    public SignatureData signMessage(String messageHash) {
        ECKeyPair keyPair = ECKeyPair.create((BigInteger)Numeric.toBigInt((String)this.privateKey));
        Sign.SignatureData signatureData = Sign.signMessage((byte[])Numeric.hexStringToByteArray((String)messageHash), (ECKeyPair)keyPair, (boolean)false);
        SignatureData signData = new SignatureData(signatureData.getV(), signatureData.getR(), signatureData.getS());
        return signData;
    }

    public String getPublicKey(boolean compressed) {
        BigInteger publicKey = Sign.publicKeyFromPrivate((BigInteger)Numeric.toBigInt((String)this.privateKey));
        if (compressed) {
            return Utils.compressPublicKey(Numeric.toHexStringWithPrefixZeroPadded((BigInteger)publicKey, (int)128));
        }
        return Numeric.toHexStringNoPrefixZeroPadded((BigInteger)publicKey, (int)128);
    }

    public String getDerivedAddress() {
        BigInteger publicKey = Sign.publicKeyFromPrivate((BigInteger)Numeric.toBigInt((String)this.privateKey));
        return Numeric.prependHexPrefix((String)Keys.getAddress((BigInteger)publicKey));
    }

    public String getPrivateKey() {
        return this.privateKey;
    }
}

