/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.wallet.keyring;

import com.klaytn.caver.wallet.keyring.KeyStore;

public class KeyStoreOption {
    KeyStore.CipherParams cipherParams;
    KeyStore.IKdfParams kdfParams;
    String address;

    public KeyStoreOption(KeyStore.CipherParams cipherParams, KeyStore.IKdfParams kdfParams, String address) {
        this.cipherParams = cipherParams;
        this.kdfParams = kdfParams;
        this.address = address;
    }

    public static KeyStoreOption getDefaultOptionWithKDF(String kdfName) {
        return KeyStoreOption.getDefaultOptionWithKDF(kdfName, null);
    }

    public static KeyStoreOption getDefaultOptionWithKDF(String kdfName, String address) {
        KeyStore.IKdfParams kdfParams;
        if (kdfName.equals(KeyStore.ScryptKdfParams.getName())) {
            kdfParams = new KeyStore.ScryptKdfParams();
        } else if (kdfName.equals(KeyStore.Pbkdf2KdfParams.getName())) {
            kdfParams = new KeyStore.Pbkdf2KdfParams();
        } else {
            throw new IllegalArgumentException("Not supported kdf method.");
        }
        return new KeyStoreOption(new KeyStore.CipherParams(), kdfParams, address);
    }

    public KeyStore.CipherParams getCipherParams() {
        return this.cipherParams;
    }

    public KeyStore.IKdfParams getKdfParams() {
        return this.kdfParams;
    }

    public String getAddress() {
        return this.address;
    }

    public void setCipherParams(KeyStore.CipherParams cipherParams) {
        this.cipherParams = cipherParams;
    }

    public void setKdfParams(KeyStore.IKdfParams kdfParams) {
        this.kdfParams = kdfParams;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

