/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.utils;

import com.klaytn.caver.utils.AccountKeyPublicUtils;
import com.klaytn.caver.utils.SecureRandomUtils;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.List;
import java.util.regex.Pattern;
import org.bouncycastle.math.ec.ECPoint;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class Utils {
    public static final int LENGTH_ADDRESS_STRING = 40;
    public static final int LENGTH_PRIVATE_KEY_STRING = 64;
    public static final String DEFAULT_ZERO_ADDRESS = "0x0000000000000000000000000000000000000000";

    public static boolean isAddress(String address) {
        Pattern baseAddrPattern = Pattern.compile("^(0x)?[0-9a-f]{40}$", 2);
        Pattern lowerCase = Pattern.compile("^(0x|0X)?[0-9a-f]{40}$");
        Pattern upperCase = Pattern.compile("^(0x|0X)?[0-9A-F]{40}$");
        if (!baseAddrPattern.matcher(address).matches()) {
            return false;
        }
        if (lowerCase.matcher(address).matches() || upperCase.matcher(address).matches()) {
            return true;
        }
        return Utils.checkAddressChecksum(address);
    }

    public static boolean checkAddressChecksum(String address) {
        address = address.replaceFirst("0X", "0x");
        return Keys.toChecksumAddress((String)address).equals(Utils.addHexPrefix(address));
    }

    public static boolean isValidPrivateKey(String privateKey) {
        String noHexPrefixKey = Numeric.cleanHexPrefix((String)privateKey);
        if (noHexPrefixKey.length() != 64 && Utils.isHex(privateKey)) {
            return false;
        }
        ECPoint point = Sign.publicPointFromPrivate((BigInteger)Numeric.toBigInt((String)privateKey));
        return point.isValid();
    }

    public static boolean isKlaytnWalletKey(String key) {
        if ((key = Numeric.cleanHexPrefix((String)key)).length() != 110) {
            return false;
        }
        String[] arr = key.split("0x");
        if (!arr[1].equals("00")) {
            return false;
        }
        if (!Utils.isAddress(arr[2])) {
            return false;
        }
        return Utils.isValidPrivateKey(arr[0]);
    }

    public static boolean isValidPublicKey(String publicKey) {
        boolean result;
        String noPrefixPubKey = Numeric.cleanHexPrefix((String)publicKey);
        if (noPrefixPubKey.length() == 130 && noPrefixPubKey.startsWith("04")) {
            noPrefixPubKey = noPrefixPubKey.substring(2);
        }
        if (noPrefixPubKey.length() != 66 && noPrefixPubKey.length() != 128) {
            return false;
        }
        if (noPrefixPubKey.length() == 66) {
            if (!noPrefixPubKey.startsWith("02") && !noPrefixPubKey.startsWith("03")) {
                return false;
            }
            result = AccountKeyPublicUtils.validateXYPoint(publicKey);
        } else {
            String x = noPrefixPubKey.substring(0, 64);
            String y = noPrefixPubKey.substring(64);
            result = AccountKeyPublicUtils.validateXYPoint(x, y);
        }
        return result;
    }

    public static String decompressPublicKey(String publicKey) {
        if (AccountKeyPublicUtils.isUncompressedPublicKey(publicKey)) {
            return publicKey;
        }
        ECPoint ecPoint = AccountKeyPublicUtils.getECPoint(publicKey);
        String pointXY = Numeric.toHexStringWithPrefixZeroPadded((BigInteger)ecPoint.getAffineXCoord().toBigInteger(), (int)64) + Numeric.toHexStringNoPrefixZeroPadded((BigInteger)ecPoint.getAffineYCoord().toBigInteger(), (int)64);
        return pointXY;
    }

    public static String compressPublicKey(String publicKey) {
        if (AccountKeyPublicUtils.isCompressedPublicKey(publicKey)) {
            return publicKey;
        }
        String noPrefixKey = Numeric.cleanHexPrefix((String)publicKey);
        if (noPrefixKey.length() == 130 && noPrefixKey.startsWith("04")) {
            noPrefixKey = noPrefixKey.substring(2);
        }
        BigInteger publicKeyBN = Numeric.toBigInt((String)noPrefixKey);
        String publicKeyX = noPrefixKey.substring(0, 64);
        String pubKeyYPrefix = publicKeyBN.testBit(0) ? "03" : "02";
        return pubKeyYPrefix + publicKeyX;
    }

    public static String hashMessage(String message) {
        String preamble = "\\x19Klaytn Signed Message:\\n";
        String klaytnMessage = "\\x19Klaytn Signed Message:\\n" + message.length() + message;
        return Hash.sha3((String)klaytnMessage);
    }

    public static String[] parseKlaytnWalletKey(String key) {
        if (!Utils.isKlaytnWalletKey(key)) {
            throw new IllegalArgumentException("Invalid Klaytn wallet key.");
        }
        key = Numeric.cleanHexPrefix((String)key);
        String[] arr = key.split("0x");
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Numeric.prependHexPrefix((String)arr[i]);
        }
        return arr;
    }

    public static boolean isHex(String input) {
        Pattern pattern = Pattern.compile("^(-0x|0x)?[0-9A-Fa-f]*$");
        return pattern.matcher(input).matches();
    }

    public static boolean isHexStrict(String input) {
        Pattern pattern = Pattern.compile("^(-)?0x[0-9A-Fa-f]*$");
        return pattern.matcher(input).matches();
    }

    public static String addHexPrefix(String str) {
        return Numeric.prependHexPrefix((String)str);
    }

    public static String stripHexPrefix(String str) {
        return Numeric.cleanHexPrefix((String)str);
    }

    public static String convertToPeb(String num, String unit) {
        return Utils.convertToPeb(new BigDecimal(num), KlayUnit.fromString(unit));
    }

    public static String convertToPeb(BigDecimal num, String unit) {
        return Utils.convertToPeb(num, KlayUnit.fromString(unit));
    }

    public static String convertToPeb(String num, KlayUnit unit) {
        return Utils.convertToPeb(new BigDecimal(num), unit);
    }

    public static String convertToPeb(BigDecimal num, KlayUnit unit) {
        return num.multiply(unit.getPebFactor()).toString();
    }

    public static String convertFromPeb(String num, String unit) {
        return Utils.convertFromPeb(new BigDecimal(num), KlayUnit.fromString(unit));
    }

    public static String convertFromPeb(BigDecimal num, String unit) {
        return Utils.convertFromPeb(num, KlayUnit.fromString(unit));
    }

    public static String convertFromPeb(String num, KlayUnit unit) {
        return Utils.convertFromPeb(new BigDecimal(num), unit).toString();
    }

    public static String convertFromPeb(BigDecimal num, KlayUnit unit) {
        return num.divide(unit.getPebFactor()).toString();
    }

    public static String recover(String message, SignatureData signatureData) throws SignatureException {
        return Utils.recover(message, signatureData, false);
    }

    public static String recover(String message, SignatureData signatureData, boolean isPrefixed) throws SignatureException {
        String messageHash = message;
        if (!isPrefixed) {
            messageHash = Utils.hashMessage(message);
        }
        byte[] r = Numeric.hexStringToByteArray((String)signatureData.getR());
        byte[] s = Numeric.hexStringToByteArray((String)signatureData.getS());
        if (r == null || r.length != 32) {
            throw new IllegalArgumentException("r must be 32 bytes");
        }
        if (s == null || s.length != 32) {
            throw new IllegalArgumentException("s must be 32 bytes");
        }
        int header = Numeric.toBigInt((String)signatureData.getV()).intValue() & 0xFF;
        if (header < 27 || header > 34) {
            throw new SignatureException("Header byte out of range: " + header);
        }
        int recId = header - 27;
        ECDSASignature sig = new ECDSASignature(new BigInteger(1, r), new BigInteger(1, s));
        BigInteger key = Sign.recoverFromSignature((int)recId, (ECDSASignature)sig, (byte[])Numeric.hexStringToByteArray((String)messageHash));
        if (key == null) {
            throw new SignatureException("Could not recover public key from signature");
        }
        return Numeric.prependHexPrefix((String)Keys.getAddress((BigInteger)key));
    }

    public static boolean isNumber(String input) {
        try {
            Numeric.toBigInt((String)input);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isEmptySig(SignatureData signatureData) {
        SignatureData emptySig = SignatureData.getEmptySignature();
        return emptySig.equals(signatureData);
    }

    public static boolean isEmptySig(List<SignatureData> signatureDataList) {
        SignatureData emptySig = SignatureData.getEmptySignature();
        boolean isMatched = signatureDataList.stream().allMatch(emptySig::equals);
        return isMatched;
    }

    public static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SecureRandomUtils.secureRandom().nextBytes(bytes);
        return bytes;
    }

    public static enum KlayUnit {
        peb("peb", 0),
        kpeb("kpeb", 3),
        Mpeb("Mpeb", 6),
        Gpeb("Gpeb", 9),
        ston("ston", 9),
        uKLAY("uKLAY", 12),
        mKLAY("mKLAY", 15),
        KLAY("KLAY", 18),
        kKLAY("kKLAY", 21),
        MKLAY("MKLAY", 24),
        GKLAY("GKLAY", 27),
        TKLAY("TKLAY", 30);

        private String unit;
        private BigDecimal pebFactor;

        private KlayUnit(String unit, int factor) {
            this.unit = unit;
            this.pebFactor = BigDecimal.TEN.pow(factor);
        }

        public BigDecimal getPebFactor() {
            return this.pebFactor;
        }

        public String toString() {
            return this.unit;
        }

        public static KlayUnit fromString(String unitName) {
            if (unitName != null) {
                for (KlayUnit unit : KlayUnit.values()) {
                    if (!unitName.equals(unit.unit)) continue;
                    return unit;
                }
            }
            return KlayUnit.valueOf(unitName);
        }
    }
}

