/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.utils;

import com.klaytn.caver.tx.account.AccountKeyPublic;
import com.klaytn.caver.utils.Utils;
import java.math.BigInteger;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.web3j.utils.Numeric;

public class AccountKeyPublicUtils {
    public static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());

    @Deprecated
    public static String toCompressedPublicKey(BigInteger publicKey) {
        String hexStringPublicKey = Numeric.toHexStringNoPrefixZeroPadded((BigInteger)publicKey, (int)128);
        String publicKeyX = hexStringPublicKey.substring(0, 64);
        String pubKeyYPrefix = publicKey.testBit(0) ? "03" : "02";
        return pubKeyYPrefix + publicKeyX;
    }

    @Deprecated
    public static AccountKeyPublic decompressKey(String compressedPublicKey) {
        boolean yBit = Numeric.cleanHexPrefix((String)compressedPublicKey).substring(0, 2).equals("03");
        BigInteger xBN = Numeric.toBigInt((String)compressedPublicKey.substring(2));
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        ECPoint ecPoint = CURVE.getCurve().decodePoint(compEnc);
        return AccountKeyPublic.create(Numeric.toHexStringWithPrefixZeroPadded((BigInteger)ecPoint.getAffineXCoord().toBigInteger(), (int)64), Numeric.toHexStringWithPrefixZeroPadded((BigInteger)ecPoint.getAffineYCoord().toBigInteger(), (int)64));
    }

    public static ECPoint getECPoint(String key) {
        if (AccountKeyPublicUtils.isUncompressedPublicKey(key)) {
            key = Utils.compressPublicKey(key);
        }
        String noPrefixPublicKey = Numeric.cleanHexPrefix((String)key);
        boolean yBit = noPrefixPublicKey.startsWith("03");
        BigInteger xBN = Numeric.toBigInt((String)noPrefixPublicKey);
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        ECPoint ecPoint = CURVE.getCurve().decodePoint(compEnc);
        return ecPoint;
    }

    public static ECPoint getECPoint(String x, String y) {
        BigInteger bigIntegerX = Numeric.toBigInt((String)x);
        BigInteger bigIntegerY = Numeric.toBigInt((String)y);
        ECPoint ecPoint = CURVE.getCurve().createPoint(bigIntegerX, bigIntegerY);
        return ecPoint;
    }

    public static boolean validateXYPoint(String compressedPubKey) {
        ECPoint point = AccountKeyPublicUtils.getECPoint(compressedPubKey);
        return point.isValid();
    }

    public static boolean validateXYPoint(String x, String y) {
        ECPoint point = AccountKeyPublicUtils.getECPoint(x, y);
        return point.isValid();
    }

    public static boolean isCompressedPublicKey(String key) {
        String noPrefixKey = Numeric.cleanHexPrefix((String)key);
        if (noPrefixKey.length() == 66 && (noPrefixKey.startsWith("02") || noPrefixKey.startsWith("03"))) {
            if (!AccountKeyPublicUtils.validateXYPoint(noPrefixKey)) {
                throw new RuntimeException("Invalid public key.");
            }
            return true;
        }
        return false;
    }

    public static boolean isUncompressedPublicKey(String key) {
        String noPrefixKey = Numeric.cleanHexPrefix((String)key);
        if (noPrefixKey.length() == 130 && noPrefixKey.startsWith("04")) {
            noPrefixKey = noPrefixKey.substring(2);
        }
        if (noPrefixKey.length() == 128) {
            String y;
            String x = noPrefixKey.substring(0, 64);
            if (!AccountKeyPublicUtils.validateXYPoint(x, y = noPrefixKey.substring(64))) {
                throw new RuntimeException("Invalid public key.");
            }
            return true;
        }
        return false;
    }
}

