/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.tx.type;

import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.crypto.KlaySignatureData;
import com.klaytn.caver.tx.model.KlayRawTransaction;
import com.klaytn.caver.tx.type.AbstractTxType;
import com.klaytn.caver.tx.type.TxType;
import com.klaytn.caver.utils.KlaySignatureDataUtils;
import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@Deprecated
public class TxTypeLegacyTransaction
extends AbstractTxType {
    private String data;

    protected TxTypeLegacyTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        super(nonce, gasPrice, gasLimit, "", to, value);
        if (data != null) {
            this.data = Numeric.cleanHexPrefix((String)data);
        }
    }

    public static TxTypeLegacyTransaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String to, BigInteger value, String data) {
        return new TxTypeLegacyTransaction(nonce, gasPrice, gasLimit, to, value, data);
    }

    public static TxTypeLegacyTransaction decodeFromRawTransaction(byte[] rawTransaction) {
        try {
            RlpList rlpList = RlpDecoder.decode((byte[])rawTransaction);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
            BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
            BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
            String to = ((RlpString)values.get(3)).asString();
            BigInteger value = ((RlpString)values.get(4)).asPositiveBigInteger();
            String input = ((RlpString)values.get(5)).asString();
            TxTypeLegacyTransaction tx = TxTypeLegacyTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, input);
            byte[] v = ((RlpString)values.get(6)).getBytes();
            byte[] r = ((RlpString)values.get(7)).getBytes();
            byte[] s = ((RlpString)values.get(8)).getBytes();
            KlaySignatureData signatureData = new KlaySignatureData(v, r, s);
            tx.addSenderSignatureData(signatureData);
            return tx;
        }
        catch (Exception e) {
            throw new RuntimeException("There is a error in the processing of decoding tx");
        }
    }

    public static TxTypeLegacyTransaction decodeFromRawTransaction(String rawTransaction) {
        return TxTypeLegacyTransaction.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    public String getData() {
        return this.data;
    }

    @Override
    public TxType.Type getType() {
        return TxType.Type.LEGACY;
    }

    @Override
    public KlaySignatureData getSignatureData(KlayCredentials credentials, int chainId) {
        KlaySignatureData signatureData = KlaySignatureData.createKlaySignatureDataFromChainId(chainId);
        List<RlpType> result = this.rlpValues();
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getTo())));
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getData())));
        result.addAll(signatureData.toRlpList().getValues());
        byte[] encodedTransaction = RlpEncoder.encode((RlpType)new RlpList(result));
        Sign.SignatureData signedSignatureData = Sign.signMessage((byte[])encodedTransaction, (ECKeyPair)credentials.getEcKeyPair());
        KlaySignatureData eip155SignatureData = KlaySignatureDataUtils.createEip155KlaySignatureData(signedSignatureData, chainId);
        return eip155SignatureData;
    }

    @Override
    public KlayRawTransaction sign(KlayCredentials credentials, int chainId) {
        KlaySignatureData signatureData = this.getSignatureData(credentials, chainId);
        List<RlpType> result = this.rlpValues();
        String to = this.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        result.addAll(signatureData.toRlpList().getValues());
        return new KlayRawTransaction(RlpEncoder.encode((RlpType)new RlpList(result)), signatureData);
    }
}

