/*
 * Decompiled with CFR 0.152.
 */
package com.klaytn.caver.tx.type;

import com.klaytn.caver.crypto.KlayCredentials;
import com.klaytn.caver.tx.account.AccountKey;
import com.klaytn.caver.tx.account.AccountKeyDecoder;
import com.klaytn.caver.tx.type.TxType;
import com.klaytn.caver.tx.type.TxTypeFeeDelegate;
import com.klaytn.caver.utils.KlayTransactionUtils;
import java.math.BigInteger;
import java.util.List;
import org.web3j.crypto.ECKeyPair;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

@Deprecated
public class TxTypeFeeDelegatedAccountUpdate
extends TxTypeFeeDelegate {
    private final AccountKey accountKey;

    public TxTypeFeeDelegatedAccountUpdate(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, AccountKey accountKey) {
        super(nonce, gasPrice, gasLimit, from, "", BigInteger.ZERO);
        this.accountKey = accountKey;
    }

    public static TxTypeFeeDelegatedAccountUpdate createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String from, AccountKey accountKey) {
        return new TxTypeFeeDelegatedAccountUpdate(nonce, gasPrice, gasLimit, from, accountKey);
    }

    public AccountKey getAccountKey() {
        return this.accountKey;
    }

    @Override
    public List<RlpType> rlpValues() {
        List<RlpType> values = super.rlpValues();
        values.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)this.getFrom())));
        values.add((RlpType)RlpString.create((byte[])this.getAccountKey().toRlp()));
        return values;
    }

    @Override
    public TxType.Type getType() {
        return TxType.Type.FEE_DELEGATED_ACCOUNT_UPDATE;
    }

    public static TxTypeFeeDelegatedAccountUpdate decodeFromRawTransaction(byte[] rawTransaction) {
        try {
            byte[] rawTransactionExceptType = KlayTransactionUtils.getRawTransactionNoType(rawTransaction);
            RlpList rlpList = RlpDecoder.decode((byte[])rawTransactionExceptType);
            List values = ((RlpList)rlpList.getValues().get(0)).getValues();
            BigInteger nonce = ((RlpString)values.get(0)).asPositiveBigInteger();
            BigInteger gasPrice = ((RlpString)values.get(1)).asPositiveBigInteger();
            BigInteger gasLimit = ((RlpString)values.get(2)).asPositiveBigInteger();
            String from = ((RlpString)values.get(3)).asString();
            String accountkeyRaw = ((RlpString)values.get(4)).asString();
            TxTypeFeeDelegatedAccountUpdate tx = TxTypeFeeDelegatedAccountUpdate.createTransaction(nonce, gasPrice, gasLimit, from, AccountKeyDecoder.fromRlp(accountkeyRaw));
            tx.addSignatureData(values, 5);
            return tx;
        }
        catch (Exception e) {
            throw new RuntimeException("There is a error in the processing of decoding tx");
        }
    }

    public static TxTypeFeeDelegatedAccountUpdate decodeFromRawTransaction(String rawTransaction) {
        return TxTypeFeeDelegatedAccountUpdate.decodeFromRawTransaction(Numeric.hexStringToByteArray((String)Numeric.cleanHexPrefix((String)rawTransaction)));
    }

    @Override
    protected List<ECKeyPair> getEcKeyPairsForSenderSign(KlayCredentials credentials) {
        return credentials.getEcKeyPairsForUpdateList();
    }
}

